<div>
    <?php $__env->startPush('styles'); ?>
        <style>
      /* Product detail styles */
      .product-hero {
        background: linear-gradient(135deg, rgba(0, 51, 102, 0.92), rgba(0, 0, 0, 0.88)),
          url("../Upload/homepage/our-choose-us-img2.avif") center/cover fixed no-repeat;
        color: #fff;
        padding: 180px 0 120px;
        text-align: center;
        position: relative;
        overflow: hidden;
        box-shadow: 0 4px 30px rgba(0, 0, 0, 0.3);
        perspective: 1000px;
      }
      
      .sparkle {
        position: absolute;
        width: 3px;
        height: 3px;
        border-radius: 50%;
        background-color: rgba(255, 255, 255, 0.6);
        animation: sparkle 3s infinite linear;
        box-shadow: 0 0 3px rgba(255, 255, 255, 0.8);
        pointer-events: none;
      }

      @keyframes sparkle {
        0%, 100% {
          transform: scale(0) rotate(0deg);
          opacity: 0;
        }
        50% {
          transform: scale(1) rotate(180deg);
          opacity: 1;
        }
      }
      .product-hero::before {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 120px;
        background: linear-gradient(to top, rgba(255,255,255,1), rgba(255,255,255,0));
        pointer-events: none;
        backdrop-filter: blur(4px);
      }
      .product-hero::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 100%;
        background: 
          radial-gradient(circle at center, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%),
          linear-gradient(45deg, rgba(11, 88, 166, 0.2) 0%, transparent 70%);
        animation: pulse 4s ease-in-out infinite;
      }
      .product-hero .container {
        position: relative;
        z-index: 2;
      }
      .product-hero .container::before {
        content: '';
        position: absolute;
        top: -100px;
        left: -100px;
        right: -100px;
        bottom: -100px;
        background: radial-gradient(circle at 50% 50%, rgba(255,255,255,0.1) 0%, transparent 50%);
        animation: rotateBg 20s linear infinite;
      }
      .product-hero h1 {
        font-size: 64px;
        font-weight: 800;
        margin: 0 0 25px;
        animation: slideUp 0.7s ease both;
        text-shadow: 0 2px 4px rgba(0,0,0,0.2);
        letter-spacing: -0.5px;
        background: linear-gradient(120deg, #ffffff, #e0e0e0);
        -webkit-background-clip: text;
        background-clip: text;
        -webkit-text-fill-color: transparent;
        position: relative;
      }
      .product-hero h1::after {
        content: attr(data-text);
        position: absolute;
        left: 0;
        top: 0;
        z-index: -1;
        background: linear-gradient(120deg, #ffffff, #e0e0e0);
        -webkit-background-clip: text;
        background-clip: text;
        -webkit-text-fill-color: transparent;
        filter: blur(8px);
        opacity: 0.5;
      }
      .product-hero p {
        font-size: 24px;
        line-height: 1.6;
        opacity: 0;
        max-width: 800px;
        margin: 0 auto;
        animation: fadeIn 0.9s ease 0.3s forwards;
        text-shadow: 0 1px 2px rgba(0,0,0,0.1);
      }

      .spec-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        margin: -60px 0 60px;
        position: relative;
        z-index: 1;
        perspective: 1000px;
      }
      .spec-card {
        background: linear-gradient(135deg, #ffffff, #f8fafc);
        border-radius: 16px;
        padding: 32px;
        box-shadow: 0 10px 30px rgba(0, 51, 102, 0.08);
        transition: all 0.5s cubic-bezier(0.165, 0.84, 0.44, 1);
        border: 1px solid rgba(0, 51, 102, 0.08);
        transform-style: preserve-3d;
        backface-visibility: hidden;
        position: relative;
        overflow: hidden;
        cursor: pointer;
      }
      .spec-card:hover {
        transform: translateY(-8px) rotateX(4deg) scale(1.02);
        box-shadow: 0 20px 40px rgba(0, 51, 102, 0.15),
                   0 0 20px rgba(11, 88, 166, 0.1);
        border-color: rgba(0, 51, 102, 0.2);
        background: linear-gradient(135deg, #f8fafc, #ffffff);
      }
      .spec-card::after {
        content: '';
        position: absolute;
        inset: 0;
        background: radial-gradient(circle at var(--mouse-x, 50%) var(--mouse-y, 50%), 
                                  rgba(255, 255, 255, 0.8) 0%,
                                  transparent 60%);
        opacity: 0;
        transition: opacity 0.3s;
        mix-blend-mode: soft-light;
        pointer-events: none;
      }
      .spec-card:hover::after {
        opacity: 1;
      }
      .spec-card .card-overlay {
        position: absolute;
        inset: 0;
        background: linear-gradient(120deg, 
                                  transparent 20%, 
                                  rgba(255, 255, 255, 0.1) 25%,
                                  rgba(255, 255, 255, 0.15) 27%,
                                  transparent 30%);
        transform: translateX(-100%);
        transition: transform 0.7s;
      }
      .spec-card:hover .card-overlay {
        transform: translateX(100%);
      }
      .spec-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: translateX(-100%);
        transition: 0.5s;
      }
      .spec-card:hover::before {
        transform: translateX(100%);
      }
      .spec-card h3 {
        color: #003366;
        margin: 0 0 20px;
        font-size: 22px;
        font-weight: 600;
        position: relative;
        padding-bottom: 15px;
      }
      .spec-card h3::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 40px;
        height: 3px;
        background: #0b58a6;
        border-radius: 2px;
      }
      .spec-card ul {
        list-style: none;
        padding: 0;
        margin: 0;
        counter-reset: item;
      }
      .spec-card li {
        padding-left: 35px;
        position: relative;
        margin-bottom: 16px;
        color: #2d3748;
        font-size: 16px;
        line-height: 1.5;
        transition: all 0.3s ease;
      }
      .spec-card li::before {
        content: "";
        position: absolute;
        left: 0;
        top: 2px;
        width: 20px;
        height: 20px;
        background: linear-gradient(135deg, #0b58a6, #003366);
        border-radius: 50%;
        box-shadow: 0 2px 8px rgba(11, 88, 166, 0.2);
        transition: all 0.3s ease;
        opacity: 0.8;
      }
      .spec-card li::after {
        content: "→";
        position: absolute;
        left: 6px;
        top: 2px;
        color: white;
        font-size: 12px;
        transition: all 0.3s ease;
      }
      .spec-card li:hover {
        transform: translateX(5px);
        color: #0b58a6;
      }
      .spec-card li:hover::before {
        transform: scale(1.2);
        opacity: 1;
      }
      .spec-card li:hover::after {
        transform: translateX(2px);
      }

      .product-content {
        max-width: 1000px;
        margin: 0 auto;
        padding: 60px 20px;
      }
      .product-content h2 {
        color: #042a45;
        margin: 40px 0 24px;
        font-size: 32px;
        font-weight: 700;
        position: relative;
        padding-left: 20px;
        letter-spacing: -0.5px;
        background: linear-gradient(120deg, #042a45, #0b58a6);
        -webkit-background-clip: text;
        background-clip: text;
        -webkit-text-fill-color: transparent;
        display: inline-block;
        transition: all 0.3s ease;
        cursor: pointer;
      }
      .product-content h2:hover {
        transform: translateX(10px);
        background: linear-gradient(120deg, #0b58a6, #042a45);
        -webkit-background-clip: text;
        background-clip: text;
      }
      .product-content h2 .icon {
        position: absolute;
        left: -10px;
        top: 50%;
        transform: translateY(-50%);
        opacity: 0;
        transition: all 0.3s ease;
        color: #0b58a6;
      }
      .product-content h2:hover .icon {
        left: -30px;
        opacity: 1;
      }
      .product-content h2::before {
        content: '';
        position: absolute;
        left: 0;
        top: 8px;
        bottom: 8px;
        width: 4px;
        background: linear-gradient(to bottom, #0b58a6, #003366);
        border-radius: 2px;
        box-shadow: 0 0 10px rgba(11, 88, 166, 0.3);
      }
      .product-content h2::after {
        content: '';
        position: absolute;
        left: 20px;
        bottom: -4px;
        width: 40px;
        height: 2px;
        background: linear-gradient(90deg, #0b58a6, transparent);
      }
      .product-content p {
        line-height: 1.8;
        color: #2d3748;
        margin-bottom: 28px;
        font-size: 17px;
        opacity: 0.9;
        text-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);
        position: relative;
        padding-left: 20px;
        transition: all 0.3s ease;
      }
      .product-content p:hover {
        transform: translateX(5px);
        color: #042a45;
      }
      .product-content section {
        background: linear-gradient(135deg, #fff, #f8fafc);
        border: 1px solid rgba(11, 88, 166, 0.1);
        position: relative;
        padding: 40px;
        margin: 40px 0;
        border-radius: 16px;
        overflow: hidden;
        transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
        box-shadow: 0 8px 24px rgba(0, 51, 102, 0.06);
      }
      .product-content section:hover {
        transform: translateY(-4px) scale(1.01);
        box-shadow: 0 20px 40px rgba(0, 51, 102, 0.12);
        background: linear-gradient(135deg, #f8fafc, #fff);
        border-color: rgba(11, 88, 166, 0.2);
      }
      .product-content section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #0b58a6, #003366);
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
      }
      .product-content section::after {
        content: '';
        position: absolute;
        inset: 0;
        background: radial-gradient(circle at top right, rgba(11, 88, 166, 0.03), transparent 70%);
        opacity: 0;
        transition: opacity 0.4s ease;
      }
      .product-content section:hover::before {
        transform: scaleX(1);
      }
      .product-content section:hover::after {
        opacity: 1;
      }
      
      /* Animations */
      @keyframes slideUp {
        from {
          transform: translateY(30px);
          opacity: 0;
        }
        to {
          transform: translateY(0);
          opacity: 1;
        }
      }

      @keyframes fadeIn {
        from {
          opacity: 0;
        }
        to {
          opacity: 1;
        }
      }

      @keyframes scaleIn {
        from {
          transform: scale(0.9);
          opacity: 0;
        }
        to {
          transform: scale(1);
          opacity: 1;
        }
      }

      @keyframes float {
        0% {
          transform: translateY(0px);
        }
        50% {
          transform: translateY(-10px);
        }
        100% {
          transform: translateY(0px);
        }
      }

      @keyframes pulse {
        0% { opacity: 0.4; }
        50% { opacity: 0.6; }
        100% { opacity: 0.4; }
      }

      @keyframes rotateBg {
        from {
          transform: rotate(0deg);
        }
        to {
          transform: rotate(360deg);
        }
      }

      .reveal {
        opacity: 0;
        transform: translateY(30px);
        transition: all 0.8s cubic-bezier(0.2, 0.9, 0.3, 1);
      }
      .reveal.in-view {
        opacity: 1;
        transform: translateY(0);
      }

      /* Floating Action Button */
      .floating-contact {
        position: fixed;
        bottom: 30px;
        right: 30px;
        z-index: 100;
        animation: float 3s ease-in-out infinite;
      }
      
      .floating-btn {
        background: linear-gradient(135deg, #0b58a6, #003366);
        color: white;
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 15px rgba(11, 88, 166, 0.3);
        cursor: pointer;
        transition: all 0.3s ease;
      }

      .floating-btn:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 20px rgba(11, 88, 166, 0.4);
      }

      .floating-btn i {
        font-size: 24px;
      }

      /* Progress bar */
      .progress-bar {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #0b58a6, #003366);
        transform-origin: 0;
        z-index: 1000;
      }

      /* Custom cursor */
      .custom-cursor {
        width: 20px;
        height: 20px;
        background: rgba(11, 88, 166, 0.3);
        border-radius: 50%;
        position: fixed;
        pointer-events: none;
        z-index: 9999;
        transition: all 0.1s ease;
        backdrop-filter: blur(2px);
      }

      .custom-cursor.active {
        transform: scale(1.5);
        background: rgba(11, 88, 166, 0.2);
      }

      /* Hover effects */
      .hover-float {
        transition: transform 0.3s ease;
      }
      .hover-float:hover {
        transform: translateY(-5px);
      }
      
      .hover-scale {
        transition: transform 0.3s ease;
      }
      .hover-scale:hover {
        transform: scale(1.02);
      }

      /* Smooth Scrolling */
      html {
        scroll-behavior: smooth;
      }

      /* Animation Delays */
      .delay-1 {
        animation-delay: 0.2s;
      }
      .delay-2 {
        animation-delay: 0.4s;
      }
      .delay-3 {
        animation-delay: 0.6s;
      }

      /* Scroll Indicator */
      .scroll-indicator {
        position: fixed;
        right: 20px;
        top: 50%;
        transform: translateY(-50%);
        width: 2px;
        height: 100px;
        background: rgba(11, 88, 166, 0.1);
        border-radius: 1px;
        z-index: 1000;
      }
      .scroll-progress {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 0%;
        background: linear-gradient(to bottom, #0b58a6, #003366);
        transition: height 0.1s ease;
      }
      .scroll-dots {
        position: absolute;
        right: 10px;
        top: 0;
        display: flex;
        flex-direction: column;
        gap: 10px;
      }
      .scroll-dot {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: rgba(11, 88, 166, 0.2);
        transition: all 0.3s ease;
        cursor: pointer;
      }
      .scroll-dot.active {
        background: #0b58a6;
        transform: scale(1.5);
      }
      
      /* Mouse Trail Effect */
      .mouse-trail {
        position: fixed;
        width: 6px;
        height: 6px;
        border-radius: 50%;
        pointer-events: none;
        background: rgba(11, 88, 166, 0.3);
        transition: transform 0.1s ease;
        z-index: 9998;
      }

      /* Text Selection */
      ::selection {
        background: rgba(11, 88, 166, 0.2);
        color: #042a45;
      }

      /* Interactive Image Overlay */
      .image-overlay {
        position: relative;
        overflow: hidden;
        border-radius: 12px;
      }
      .image-overlay img {
        transition: transform 0.5s ease;
      }
      .image-overlay:hover img {
        transform: scale(1.05);
      }
      .image-overlay::after {
        content: '';
        position: absolute;
        inset: 0;
        background: radial-gradient(circle at var(--mouse-x, 50%) var(--mouse-y, 50%),
                                  rgba(11, 88, 166, 0.2) 0%,
                                  transparent 60%);
        opacity: 0;
        transition: opacity 0.3s;
        mix-blend-mode: overlay;
      }
      .image-overlay:hover::after {
        opacity: 1;
      }
    </style>
    <?php $__env->stopPush(); ?>
       <section class="product-hero">
        <div class="container">
          <h1 class="reveal hover-scale delay-1" data-text="Aluminium Alloys">Aluminium Alloys</h1>
          <p class="reveal hover-float delay-2">Custom aluminium alloys produced from recycled scrap for diverse industrial applications</p>
        </div>
      </section>

      <div class="container">
        <div class="spec-grid">
          <div class="spec-card reveal hover-scale delay-1">
            <h3>Key Features</h3>
            <ul class="reveal delay-2">
              <li class="hover-float">High-quality recycled aluminium alloys</li>
              <li class="hover-float">Custom compositions available</li>
              <li class="hover-float">Strict quality control</li>
              <li class="hover-float">Environmental compliance</li>
              <li class="hover-float">ISO 9001:2015 certified process</li>
            </ul>
          </div>

          <div class="spec-card reveal">
            <h3>Applications</h3>
            <ul>
              <li>Automotive components</li>
              <li>Construction materials</li>
              <li>Electronics manufacturing</li>
              <li>Consumer goods</li>
              <li>Industrial machinery</li>
            </ul>
          </div>

          <div class="spec-card reveal">
            <h3>Specifications</h3>
            <ul>
              <li>Alloy series: 1000-7000</li>
              <li>Custom compositions</li>
              <li>ASTM/EN standards</li>
              <li>Batch testing available</li>
              <li>Full documentation</li>
            </ul>
          </div>
        </div>

        <div class="product-content">
          <h2>Product Overview</h2>
          <p>Our recycled aluminium alloys are produced using state-of-the-art technology and rigorous quality control processes. We specialize in creating custom alloy compositions tailored to specific industrial applications, ensuring optimal performance and sustainability.</p>

          <h2>Manufacturing Process</h2>
          <p>The manufacturing process begins with careful selection and sorting of recycled aluminium scrap. Our advanced processing facilities employ the latest technology in metal recycling and refining to produce high-quality aluminium alloys that meet international standards.</p>

          <h2>Quality Assurance</h2>
          <p>Every batch undergoes comprehensive testing and analysis to ensure consistency and quality. Our ISO 9001:2015 certified processes guarantee that all products meet the specified chemical composition and physical properties required by our customers.</p>

          <h2>Sustainability</h2>
          <p>By using recycled aluminium, we significantly reduce environmental impact compared to primary aluminium production. Our process saves up to 95% of the energy required for primary aluminium production while maintaining the same high quality standards.</p>
        </div>
      </div>
    <?php $__env->startPush('scripts'); ?>
         <script>
      document.addEventListener("DOMContentLoaded", function () {
        // Add sparkles to hero section
        const hero = document.querySelector('.product-hero');
        for (let i = 0; i < 20; i++) {
          const sparkle = document.createElement('div');
          sparkle.className = 'sparkle';
          sparkle.style.left = Math.random() * 100 + '%';
          sparkle.style.top = Math.random() * 100 + '%';
          sparkle.style.animationDelay = Math.random() * 3 + 's';
          hero.appendChild(sparkle);
        }

        // Add scroll indicator
        const scrollIndicator = document.createElement('div');
        scrollIndicator.className = 'scroll-indicator';
        scrollIndicator.innerHTML = `
          <div class="scroll-progress"></div>
          <div class="scroll-dots"></div>
        `;
        document.body.appendChild(scrollIndicator);

        // Add section dots
        const sections = document.querySelectorAll('section, .product-content h2');
        const scrollDots = document.querySelector('.scroll-dots');
        sections.forEach(() => {
          const dot = document.createElement('div');
          dot.className = 'scroll-dot';
          scrollDots.appendChild(dot);
        });

        // Mouse trail effect
        const trails = Array.from({length: 5}, (_, i) => {
          const trail = document.createElement('div');
          trail.className = 'mouse-trail';
          trail.style.opacity = 1 - (i * 0.2);
          document.body.appendChild(trail);
          return trail;
        });

        let mouseX = 0, mouseY = 0;
        let trailX = Array(5).fill(0);
        let trailY = Array(5).fill(0);

        document.addEventListener('mousemove', (e) => {
          mouseX = e.clientX;
          mouseY = e.clientY;

          // Update card highlight effect
          document.querySelectorAll('.spec-card').forEach(card => {
            const rect = card.getBoundingClientRect();
            const x = ((e.clientX - rect.left) / rect.width) * 100;
            const y = ((e.clientY - rect.top) / rect.height) * 100;
            card.style.setProperty('--mouse-x', `${x}%`);
            card.style.setProperty('--mouse-y', `${y}%`);
          });
        });

        function updateTrails() {
          for (let i = 0; i < trails.length; i++) {
            trailX[i] += (mouseX - trailX[i]) * (0.2 / (i + 1));
            trailY[i] += (mouseY - trailY[i]) * (0.2 / (i + 1));
            trails[i].style.transform = `translate(${trailX[i]}px, ${trailY[i]}px)`;
          }
          requestAnimationFrame(updateTrails);
        }
        updateTrails();

        // Reveal animations
        const reveals = document.querySelectorAll(".reveal");
        const observer = new IntersectionObserver((entries) => {
          entries.forEach(entry => {
            if (entry.isIntersecting) {
              entry.target.classList.add("in-view");
            }
          });
        }, {
          threshold: 0.1
        });

        reveals.forEach(element => observer.observe(element));

        // Custom cursor
        const cursor = document.createElement("div");
        cursor.classList.add("custom-cursor");
        document.body.appendChild(cursor);

        document.addEventListener("mousemove", (e) => {
          cursor.style.left = e.clientX + "px";
          cursor.style.top = e.clientY + "px";
        });

        document.addEventListener("mousedown", () => cursor.classList.add("active"));
        document.addEventListener("mouseup", () => cursor.classList.remove("active"));

        // Progress bar
        const progressBar = document.createElement("div");
        progressBar.classList.add("progress-bar");
        document.body.appendChild(progressBar);

        window.addEventListener("scroll", () => {
          const winScroll = document.documentElement.scrollTop;
          const height = document.documentElement.scrollHeight - document.documentElement.clientHeight;
          const scrolled = (winScroll / height) * 100;
          progressBar.style.transform = `scaleX(${scrolled / 100})`;
        });

        // Floating contact button
        const floatingContact = document.createElement("div");
        floatingContact.classList.add("floating-contact");
        floatingContact.innerHTML = `
          <div class="floating-btn">
            <i class="fas fa-envelope"></i>
          </div>
        `;
        document.body.appendChild(floatingContact);

        floatingContact.addEventListener("click", () => {
          window.location.href = "mailto:info@eeyametak.com";
        });

        // Performance optimization
        let requestId;
        let lastKnownScrollPosition = 0;
        let ticking = false;

        function onScroll() {
          lastKnownScrollPosition = window.scrollY;
          if (!ticking) {
            requestId = window.requestAnimationFrame(() => {
              // Update animations based on scroll position
              ticking = false;
            });
            ticking = true;
          }
        }

        window.addEventListener("scroll", onScroll, { passive: true });

        // Cleanup
        return () => {
          if (requestId) {
            window.cancelAnimationFrame(requestId);
          }
          window.removeEventListener("scroll", onScroll);
        };
      });
    </script>
    <?php $__env->stopPush(); ?>
</div>
<?php /**PATH E:\eeyametal_project\eeyametal_laravel\resources\views/livewire/aluminius-alloys-livewire.blade.php ENDPATH**/ ?>