<div>
    <?php $__env->startPush('styles'); ?>
        <style>
      /* Product detail styles */
      .product-hero {
        background: linear-gradient(135deg, rgba(0, 51, 102, 0.9), rgba(0, 0, 0, 0.85)),
          url("../Upload/homepage/trust-img.avif") center/cover fixed no-repeat;
        color: #fff;
        padding: 180px 0 120px;
        text-align: center;
        position: relative;
        overflow: hidden;
      }
      .product-hero::before {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 120px;
        background: linear-gradient(to top, rgba(255,255,255,1), rgba(255,255,255,0));
        pointer-events: none;
      }
      .product-hero::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 100%;
        background: radial-gradient(circle at center, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
        animation: pulse 4s ease-in-out infinite;
      }
      .product-hero h1 {
        font-size: 64px;
        font-weight: 800;
        margin: 0 0 25px;
        animation: slideUp 0.7s ease both;
        text-shadow: 0 2px 4px rgba(0,0,0,0.2);
        letter-spacing: -0.5px;
        background: linear-gradient(120deg, #ffffff, #e0e0e0);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        position: relative;
      }
      .product-hero h1::after {
        content: attr(data-text);
        position: absolute;
        left: 0;
        top: 0;
        z-index: -1;
        background: linear-gradient(120deg, #ffffff, #e0e0e0);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        filter: blur(8px);
        opacity: 0.5;
      }
      .product-hero p {
        font-size: 24px;
        line-height: 1.6;
        opacity: 0;
        max-width: 800px;
        margin: 0 auto;
        animation: fadeIn 0.9s ease 0.3s forwards;
        text-shadow: 0 1px 2px rgba(0,0,0,0.1);
      }
      
      @keyframes pulse {
        0% { opacity: 0.4; }
        50% { opacity: 0.6; }
        100% { opacity: 0.4; }
      }

      .spec-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        margin: -60px 0 60px;
        position: relative;
        z-index: 1;
        perspective: 1000px;
      }
      .spec-card {
        background: #fff;
        border-radius: 16px;
        padding: 32px;
        box-shadow: 0 10px 30px rgba(0, 51, 102, 0.08);
        transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
        border: 1px solid rgba(0, 51, 102, 0.08);
        transform-style: preserve-3d;
        backface-visibility: hidden;
      }
      .spec-card:hover {
        transform: translateY(-8px) rotateX(4deg);
        box-shadow: 0 20px 40px rgba(0, 51, 102, 0.15);
        border-color: rgba(0, 51, 102, 0.2);
      }
      .spec-card:hover::after {
        opacity: 1;
      }
      .spec-card::after {
        content: '';
        position: absolute;
        inset: 0;
        border-radius: 16px;
        background: linear-gradient(
          135deg,
          rgba(255, 255, 255, 0.2) 0%,
          rgba(255, 255, 255, 0) 60%
        );
        opacity: 0;
        transition: opacity 0.3s ease;
        pointer-events: none;
      }
      .spec-card h3 {
        color: #003366;
        margin: 0 0 20px;
        font-size: 22px;
        font-weight: 600;
        position: relative;
        padding-bottom: 15px;
      }
      .spec-card h3::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 40px;
        height: 3px;
        background: #0b58a6;
        border-radius: 2px;
      }
      .spec-card ul {
        list-style: none;
        padding: 0;
        margin: 0;
      }
      .spec-card li {
        padding-left: 28px;
        position: relative;
        margin-bottom: 12px;
        color: #2d3748;
        font-size: 16px;
        line-height: 1.5;
      }
      .spec-card li::before {
        content: "";
        position: absolute;
        left: 0;
        top: 8px;
        width: 6px;
        height: 6px;
        background: #0b58a6;
        border-radius: 50%;
        box-shadow: 0 0 0 4px rgba(11, 88, 166, 0.1);
      }

      .product-content {
        max-width: 1000px;
        margin: 0 auto;
        padding: 60px 20px;
      }
      .product-content h2 {
        color: #042a45;
        margin: 40px 0 24px;
        font-size: 32px;
        font-weight: 600;
        position: relative;
        padding-left: 20px;
      }
      .product-content h2::before {
        content: '';
        position: absolute;
        left: 0;
        top: 8px;
        bottom: 8px;
        width: 4px;
        background: #0b58a6;
        border-radius: 2px;
      }
      .product-content p {
        line-height: 1.8;
        color: #2d3748;
        margin-bottom: 24px;
        font-size: 17px;
        opacity: 0.9;
      }
      .product-content section {
        background: #f8fafc;
        border-radius: 16px;
        padding: 40px;
        margin: 40px 0;
        position: relative;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
      }
      .product-content section:hover {
        transform: translateY(-4px);
        box-shadow: 0 15px 30px rgba(0, 51, 102, 0.08);
      }
      .product-content section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #0b58a6, #003366);
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.3s ease;
      }
      .product-content section:hover::before {
        transform: scaleX(1);
      }
      .product-content section h2 {
        margin-top: 0;
        transition: color 0.3s ease;
      }
      .product-content section:hover h2 {
        color: #0b58a6;
      }
      
      .product-content ul {
        list-style: none;
        padding: 0;
        margin: 20px 0;
      }
      
      .product-content ul li {
        position: relative;
        padding-left: 28px;
        margin-bottom: 12px;
        color: #2d3748;
        font-size: 16px;
        line-height: 1.6;
      }
      
      .product-content ul li::before {
        content: "✓";
        position: absolute;
        left: 0;
        color: #0b58a6;
        font-weight: bold;
      }

      @media (max-width: 768px) {
        .product-hero {
          padding: 100px 0 80px;
        }
        .product-hero h1 {
          font-size: 42px;
        }
        .product-hero p {
          font-size: 18px;
        }
        .spec-grid {
          margin: -40px 0 40px;
          gap: 20px;
        }
        .spec-card {
          padding: 24px;
        }
        .product-content section {
          padding: 30px;
        }
        .product-content h2 {
          font-size: 28px;
        }
      }
      
      /* Animations */
      @keyframes slideUp {
        from {
          transform: translateY(30px);
          opacity: 0;
        }
        to {
          transform: translateY(0);
          opacity: 1;
        }
      }

      @keyframes fadeIn {
        from {
          opacity: 0;
        }
        to {
          opacity: 1;
        }
      }

      @keyframes scaleIn {
        from {
          transform: scale(0.9);
          opacity: 0;
        }
        to {
          transform: scale(1);
          opacity: 1;
        }
      }

      @keyframes float {
        0% {
          transform: translateY(0px);
        }
        50% {
          transform: translateY(-10px);
        }
        100% {
          transform: translateY(0px);
        }
      }

      .reveal {
        opacity: 0;
        transform: translateY(30px);
        transition: all 0.8s cubic-bezier(0.2, 0.9, 0.3, 1);
      }
      .reveal.in-view {
        opacity: 1;
        transform: translateY(0);
      }
      
      /* Hover Effects */
      .hover-float {
        transition: transform 0.3s ease;
      }
      .hover-float:hover {
        transform: translateY(-5px);
      }
      
      .hover-scale {
        transition: transform 0.3s ease;
      }
      .hover-scale:hover {
        transform: scale(1.02);
      }

      /* Smooth Scrolling */
      html {
        scroll-behavior: smooth;
      }

      /* Animation Delays */
      .delay-1 {
        animation-delay: 0.2s;
      }
      .delay-2 {
        animation-delay: 0.4s;
      }
      .delay-3 {
        animation-delay: 0.6s;
      }

      /* Floating Action Button */
      .floating-contact {
        position: fixed;
        bottom: 30px;
        right: 30px;
        z-index: 100;
        animation: float 3s ease-in-out infinite;
      }
      
      .floating-btn {
        background: linear-gradient(135deg, #0b58a6, #003366);
        color: white;
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 15px rgba(11, 88, 166, 0.3);
        cursor: pointer;
        transition: all 0.3s ease;
      }

      .floating-btn:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 20px rgba(11, 88, 166, 0.4);
      }

      .floating-btn i {
        font-size: 24px;
      }

      /* Progress bar */
      .progress-bar {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #0b58a6, #003366);
        transform-origin: 0;
        z-index: 1000;
      }

      /* Card Glow Effect */
      .glow-effect {
        position: relative;
      }
      
      .glow-effect::before {
        content: '';
        position: absolute;
        inset: -2px;
        border-radius: 18px;
        padding: 2px;
        background: linear-gradient(135deg, #0b58a6, transparent, #003366);
        mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
        -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
        -webkit-mask-composite: xor;
        mask-composite: exclude;
        opacity: 0;
        transition: opacity 0.3s ease;
      }
      
      .glow-effect:hover::before {
        opacity: 1;
      }

      /* Enhanced section styles */
      .product-content section {
        background: linear-gradient(135deg, #fff, #f8fafc);
        border: 1px solid rgba(11, 88, 166, 0.1);
        position: relative;
        padding: 40px;
        margin: 40px 0;
      }

      .product-content section:hover {
        background: linear-gradient(135deg, #f8fafc, #fff);
      }

      .section-icon {
        position: absolute;
        top: -20px;
        left: 40px;
        background: white;
        padding: 10px;
        border-radius: 50%;
        box-shadow: 0 4px 15px rgba(11, 88, 166, 0.1);
      }

      .content-wrapper {
        margin-top: 20px;
      }

      .highlight-box {
        background: rgba(11, 88, 166, 0.03);
        border-left: 4px solid #0b58a6;
        padding: 20px;
        margin: 20px 0;
        border-radius: 0 8px 8px 0;
      }

      .highlight-box strong {
        display: block;
        margin-bottom: 10px;
        color: #003366;
      }

      .process-steps {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-top: 30px;
      }

      .step {
        display: flex;
        align-items: flex-start;
        gap: 15px;
        padding: 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.03);
        transition: transform 0.3s ease;
      }

      .step:hover {
        transform: translateY(-5px);
      }

      .step-number {
        font-size: 24px;
        font-weight: 700;
        color: #0b58a6;
        opacity: 0.5;
      }

      .step-content h4 {
        margin: 0 0 8px;
        color: #003366;
        font-size: 18px;
      }

      .step-content p {
        margin: 0;
        font-size: 14px;
        color: #666;
      }

      /* Smooth cursor effect */
      .custom-cursor {
        width: 20px;
        height: 20px;
        background: rgba(11, 88, 166, 0.3);
        border-radius: 50%;
        position: fixed;
        pointer-events: none;
        z-index: 9999;
        transition: all 0.1s ease;
        backdrop-filter: blur(2px);
      }

      .custom-cursor.active {
        transform: scale(1.5);
        background: rgba(11, 88, 166, 0.2);
      }
    </style>
    <?php $__env->stopPush(); ?>
     <section class="product-hero">
        <div class="container">
          <h1>Turnkey Solutions</h1>
          <p>End-to-end project delivery for recycling plants and equipment installations</p>
        </div>
      </section>

      <div class="container">
        <div class="spec-grid">
          <div class="spec-card reveal">
            <h3>Services Offered</h3>
            <ul>
              <li>Plant design and engineering</li>
              <li>Equipment procurement</li>
              <li>Installation & commissioning</li>
              <li>Project management</li>
              <li>Training and support</li>
            </ul>
          </div>

          <div class="spec-card reveal">
            <h3>Project Types</h3>
            <ul>
              <li>Battery recycling plants</li>
              <li>Metal recycling facilities</li>
              <li>Plastic processing units</li>
              <li>E-waste handling systems</li>
              <li>Custom solutions</li>
            </ul>
          </div>

          <div class="spec-card reveal">
            <h3>Key Benefits</h3>
            <ul>
              <li>Single point responsibility</li>
              <li>Optimized project timeline</li>
              <li>Cost-effective solutions</li>
              <li>Industry best practices</li>
              <li>Ongoing technical support</li>
            </ul>
          </div>
        </div>

        <div class="product-content">
          <section class="glow-effect reveal">
            <div class="section-icon">
              <svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#0b58a6">
                <circle cx="12" cy="12" r="10" stroke-width="2"/>
                <path d="M12 6v6l4 2" stroke-width="2" stroke-linecap="round"/>
              </svg>
            </div>
            <h2>Service Overview</h2>
            <div class="content-wrapper">
              <p>Our turnkey solutions provide complete end-to-end project implementation for recycling plants and industrial installations. We handle everything from initial concept and design through to commissioning and operator training. With decades of experience in the industry, we deliver reliable and efficient solutions tailored to your specific requirements.</p>
              <div class="highlight-box">
                <strong>Why Choose Us:</strong>
                <ul>
                  <li>End-to-end project management</li>
                  <li>Experienced team of experts</li>
                  <li>Customized solutions</li>
                </ul>
              </div>
            </div>
          </section>

          <section class="glow-effect reveal">
            <div class="section-icon">
              <svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#0b58a6">
                <path d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" stroke-width="2"/>
                <path d="M12 8v4l3 3" stroke-width="2" stroke-linecap="round"/>
              </svg>
            </div>
            <h2>Project Management Excellence</h2>
            <div class="content-wrapper">
              <p>Our experienced project management team ensures smooth execution of complex installations. We coordinate all aspects including design, procurement, construction, and commissioning while maintaining strict quality and safety standards. Our proven methodology ensures:</p>
              <div class="process-steps">
                <div class="step">
                  <span class="step-number">01</span>
                  <div class="step-content">
                    <h4>Resource Planning</h4>
                    <p>Efficient resource allocation and timeline management</p>
                  </div>
                </div>
                <div class="step">
                  <span class="step-number">02</span>
                  <div class="step-content">
                    <h4>Progress Tracking</h4>
                    <p>Regular progress monitoring and reporting</p>
                  </div>
                </div>
                <div class="step">
                  <span class="step-number">03</span>
                  <div class="step-content">
                    <h4>Risk Management</h4>
                    <p>Risk assessment and mitigation strategies</p>
                  </div>
                </div>
                <div class="step">
                  <span class="step-number">04</span>
                  <div class="step-content">
                    <h4>Quality Assurance</h4>
                    <p>Quality control at every project stage</p>
                  </div>
                </div>
              </div>
            </div>
          </section>

          <section>
            <h2>Technology & Equipment</h2>
            <p>We partner with leading equipment manufacturers and technology providers to deliver state-of-the-art recycling solutions. Our systems incorporate the latest advances in automation and process control for optimal efficiency. Each solution is designed with:</p>
            <ul>
              <li>Advanced automation and control systems</li>
              <li>Energy-efficient equipment selection</li>
              <li>Scalable and modular design approach</li>
              <li>Integration with existing infrastructure</li>
            </ul>
          </section>

          <section>
            <h2>Support & Training</h2>
            <p>Post-installation support includes comprehensive operator training, maintenance programs, and ongoing technical assistance. We ensure your team is fully equipped to operate and maintain the installed systems effectively through:</p>
            <ul>
              <li>Hands-on operator training programs</li>
              <li>Detailed documentation and manuals</li>
              <li>24/7 technical support availability</li>
              <li>Regular maintenance scheduling</li>
            </ul>
          </section>
        </div>
      </div>
      <?php $__env->startPush('scripts'); ?>
           <script>
      // Create custom cursor
      const cursor = document.createElement('div');
      cursor.classList.add('custom-cursor');
      document.body.appendChild(cursor);

      // Create progress bar
      const progressBar = document.createElement('div');
      progressBar.classList.add('progress-bar');
      document.body.appendChild(progressBar);

      // Create floating action button
      const floatingContact = document.createElement('div');
      floatingContact.classList.add('floating-contact');
      floatingContact.innerHTML = `
        <div class="floating-btn">
          <i class="fas fa-phone"></i>
        </div>
      `;
      document.body.appendChild(floatingContact);

      // Update progress bar on scroll
      window.addEventListener('scroll', () => {
        const winScroll = document.body.scrollTop || document.documentElement.scrollTop;
        const height = document.documentElement.scrollHeight - document.documentElement.clientHeight;
        const scrolled = (winScroll / height) * 100;
        progressBar.style.transform = `scaleX(${scrolled / 100})`;
      });

      // Custom cursor movement
      document.addEventListener('mousemove', (e) => {
        cursor.style.left = e.clientX + 'px';
        cursor.style.top = e.clientY + 'px';
      });

      // Cursor interaction states
      document.querySelectorAll('a, button, .spec-card, .floating-btn').forEach(el => {
        el.addEventListener('mouseenter', () => cursor.classList.add('active'));
        el.addEventListener('mouseleave', () => cursor.classList.remove('active'));
      });

      // IntersectionObserver for reveal animations with staggered delay
      const io = new IntersectionObserver(
        (entries) => {
          entries.forEach((entry, index) => {
            if (entry.isIntersecting) {
              // Add staggered delay based on index
              setTimeout(() => {
                entry.target.classList.add('in-view');
              }, index * 150); // 150ms delay between each item
            }
          });
        },
        {
          threshold: 0.2,
          rootMargin: '50px'
        }
      );

      // Observe all reveal elements
      document.querySelectorAll('.reveal').forEach((el) => io.observe(el));

      // Add data-text attribute to hero title for glow effect
      const heroTitle = document.querySelector('.product-hero h1');
      if (heroTitle) {
        heroTitle.setAttribute('data-text', heroTitle.textContent);
      }

      // Add smooth parallax effect on scroll
      window.addEventListener('scroll', () => {
        const scrolled = window.pageYOffset;
        document.querySelector('.product-hero').style.backgroundPositionY = 
          `${scrolled * 0.5}px`;
      });

      // Add hover effect to spec cards
      document.querySelectorAll('.spec-card').forEach(card => {
        card.addEventListener('mousemove', (e) => {
          const rect = card.getBoundingClientRect();
          const x = e.clientX - rect.left;
          const y = e.clientY - rect.top;
          
          const centerX = rect.width / 2;
          const centerY = rect.height / 2;
          
          const rotateX = (y - centerY) / 20;
          const rotateY = (centerX - x) / 20;
          
          card.style.transform = 
            `perspective(1000px) rotateX(${rotateX}deg) rotateY(${rotateY}deg)`;
        });
        
        card.addEventListener('mouseleave', () => {
          card.style.transform = 'perspective(1000px) rotateX(0) rotateY(0)';
        });
      });
    </script>
      <?php $__env->stopPush(); ?>
</div>
<?php /**PATH E:\eeyametal_project\eeyametal_laravel\resources\views/livewire/turnkey-solution-livewire.blade.php ENDPATH**/ ?>