<div>
    <?php $__env->startPush('styles'); ?>
        <style>
            .gallery-hero {
                position: relative;
                background: transparent;
                /* height: 100vh; Full viewport height */
                /* min-height: 600px; */
                color: #fff;
                text-align: center;
                overflow: hidden;
                width: 100%;
                padding: 0;
                /* Remove padding to allow full coverage */
            }

            /* hero slider container (fills hero) */
            .hero-slider {
                position: absolute;
                inset: 0;
                z-index: 0;
                display: block;
                overflow: hidden;
                width: 100%;
                height: 100%;
            }

            .hero-slide {
                position: absolute;
                inset: 0;
                background-size: cover;
                background-position: center center;
                opacity: 0;
                width: 100%;
                height: 100%;
                transition: opacity 0.6s ease,
                    transform 0.85s cubic-bezier(0.2, 0.9, 0.3, 1);
                transform: scale(1);
                display: flex;
                align-items: center;
                justify-content: center;
            }

            /* active slide is slightly scaled up so the image reads larger */
            .hero-slide.active {
                opacity: 1;
                transform: scale(1.06);
            }

            .hero-slide::after {
                content: "";
                position: absolute;
                inset: 0;
                /* keep a very light overlay for text legibility but remove heavy black */
                background: rgba(0, 0, 0, 0.06);
                pointer-events: none;
            }

            /* keep overlay content above slides */
            .gallery-hero>.container,
            .gallery-hero .hero-overlay,
            .gallery-hero .hero-center-title {
                position: relative;
                z-index: 2;
            }

            /* hero overlay bottom-left */
            .gallery-hero .hero-overlay {
                position: absolute;
                left: 24px;
                bottom: 24px;
                background: linear-gradient(180deg,
                        rgba(0, 0, 0, 0.14),
                        rgba(0, 0, 0, 0.48));
                padding: 18px 20px;
                border-radius: 10px;
                max-width: 640px;
                color: #fff;
                box-shadow: 0 18px 40px rgba(0, 0, 0, 0.45);
                transform: translateY(18px);
                opacity: 0;
                animation: slideUpFade 0.6s cubic-bezier(0.2, 0.9, 0.3, 1) 0.12s forwards;
            }

            .gallery-hero .hero-title {
                font-size: 34px;
                margin: 0;
                color: #ffd54f;
                font-weight: 800;
                line-height: 1.04;
                text-shadow: 0 8px 24px rgba(0, 0, 0, 0.45);
            }

            .gallery-hero .hero-sub {
                margin: 8px 0 0;
                color: #ecf6ff;
                font-size: 16px;
                font-weight: 600;
            }

            .gallery-hero .hero-sub .hero-strong {
                color: #ffd54f;
                font-weight: 800;
            }

            /* centered hero title (top) */
            .hero-center-title {
                position: absolute;
                right: 32%;
                top: 36px;
                transform: translate(-50%, 12px);
                color: #fff;
                font-size: 48px;
                font-weight: 900;
                letter-spacing: 0.4px;
                text-shadow: 0 12px 40px rgba(0, 0, 0, 0.6);
                max-width: 90%;
                text-align: center;
                opacity: 0;
            }

            /* simple AOS-like helpers */
            .aos {
                opacity: 0;
                transform: translateY(18px);
                transition: opacity 0.6s cubic-bezier(0.2, 0.9, 0.3, 1),
                    transform 0.6s cubic-bezier(0.2, 0.9, 0.3, 1);
            }

            .aos.aos-animate {
                opacity: 1;
                transform: none;
            }

            @keyframes slideUpFade {
                to {
                    transform: none;
                    opacity: 1;
                }
            }

            /* Gallery grid and item styles */
            .gallery-grid {
                display: grid;
                grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
                gap: 18px;
                margin: 24px 0;

            }

            .gallery-item {
                position: relative;
                overflow: hidden;
                border-radius: 10px;
                cursor: pointer;
                background: #fff;
                border: 1px solid #eef6fb;
            }

            .gallery-item figure {
                margin: 0;
            }

            .gallery-item img {
                display: block;
                width: 100%;
                height: 260px;
                object-fit: cover;
                transition: transform 0.45s cubic-bezier(0.2, 0.9, 0.3, 1);
            }

            .gallery-item:hover img {
                transform: scale(1.06);
            }

            .item-caption {
                position: absolute;
                left: 12px;
                bottom: 12px;
                right: 12px;
                color: #fff;
                padding: 10px 12px;
                border-radius: 8px;
                background: linear-gradient(180deg,
                        rgba(0, 0, 0, 0) 0%,
                        rgba(0, 0, 0, 0.45) 60%);
                backdrop-filter: blur(4px);
                display: flex;
                justify-content: space-between;
                align-items: center;
                gap: 8px;
            }

            .item-caption .title {
                font-weight: 700;
                font-size: 14px;
                text-shadow: 0 6px 20px rgba(0, 0, 0, 0.45);
            }

            .item-badge {
                background: rgba(255, 255, 255, 0.12);
                color: #fff;
                padding: 6px 8px;
                border-radius: 999px;
                font-size: 12px;
            }

            /* Category filter buttons */
            .category-filters {
                display: flex;
                gap: 10px;
                flex-wrap: wrap;
                margin: 0 0 8px;
                /* margin top:20px; */
            }

            .category-btn {
                background: #fff;
                border: 1px solid #e6f0fb;
                padding: 8px 12px;
                border-radius: 8px;
                cursor: pointer;
                color: #043259;
                font-weight: 600;
            }

            .category-btn.active {
                background: #0366d6;
                color: #fff;
                border-color: #0366d6;
                box-shadow: 0 8px 24px rgba(3, 102, 214, 0.12);
            }

            /* Lightbox navigation */
            .lb-nav {
                position: absolute;
                top: 50%;
                left: 0;
                right: 0;
                display: flex;
                justify-content: space-between;
                pointer-events: none;
            }

            .lb-nav button {
                pointer-events: auto;
                background: rgba(0, 0, 0, 0.36);
                color: #fff;
                border: 0;
                padding: 10px 14px;
                border-radius: 8px;
                margin: 0 14px;
                cursor: pointer;
            }

            /* Lightbox overlay */
            .lb-overlay {
                position: fixed;
                inset: 0;
                background: rgba(0, 0, 0, 0.92);
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                padding: 24px;
                z-index: 9999;
                visibility: hidden;
                opacity: 0;
                transition: opacity 0.3s ease, visibility 0.3s;
            }

            .lb-overlay.open {
                visibility: visible;
                opacity: 1;
            }

            .lb-image {
                max-width: calc(100% - 40px);
                max-height: calc(70vh - 40px);
                box-shadow: 0 12px 40px rgba(0, 0, 0, 0.6);
                border-radius: 8px;
                transition: transform 0.3s ease;
            }

            .lb-close {
                position: absolute;
                top: 18px;
                right: 18px;
                color: #fff;
                background: transparent;
                border: 0;
                font-size: 28px;
                cursor: pointer;
            }

            .lb-info {
                max-width: 980px;
                margin-top: 24px;
                color: #e6eef9;
                text-align: left;
                background: rgba(0, 0, 0, 0.5);
                padding: 20px;
                border-radius: 10px;
                backdrop-filter: blur(10px);
                width: 100%;
            }

            #lbTitle {
                font-size: 24px;
                margin: 0 0 12px;
                color: #ffd54f;
                font-weight: 800;
                text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
            }

            .lb-desc {
                color: #ffffff;
                font-size: 16px;
                line-height: 1.6;
                margin-bottom: 12px;
                text-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
            }

            .lb-caption {
                color: #e6eef9;
                font-size: 14px;
                text-align: left;
                opacity: 0.9;
            }

            @media (max-width: 991px) {
                .lb-image {
                    max-height: 50vh;
                }
            }

            @media (max-width: 991px) {
                .gallery-hero {
                    padding: 88px 0 60px;
                }

                .gallery-hero .hero-title {
                    font-size: 26px;
                }

                .gallery-hero .hero-overlay {
                    left: 14px;
                    right: 14px;
                    bottom: 16px;
                }

                .hero-center-title {
                    font-size: 28px;
                    top: 18px;
                }
            }

            @media (max-width: 767px) {
                .gallery-item img {
                    height: 160px;
                }
            }
        </style>
    <?php $__env->stopPush(); ?>
    

    <!-- hero slider (3 images) -->
    
    

    <!-- centered visible title at top of hero -->
    

    

    <section class="common-padding">
        <div class="container">
            <div
                style="
              display: flex;
              justify-content: space-between;
              align-items: center;
              flex-wrap: wrap;
              gap: 12px;
                padding-top:40px;
            ">

                <h2 style="margin: 0 0 12px 0">Photo Gallery</h2>
                <div class="category-filters" role="tablist" aria-label="Gallery categories">
                    <button class="category-btn active" data-filter="all" role="tab" aria-selected="true">
                        All categories
                    </button>
                    <button class="category-btn" data-filter="operations" role="tab">
                        Operations
                    </button>
                    <button class="category-btn" data-filter="events" role="tab">
                        Events
                    </button>
                    <button class="category-btn" data-filter="awards" role="tab">
                        Awards
                    </button>
                    <button class="category-btn" data-filter="facilities" role="tab">
                        Facilities
                    </button>
                </div>
            </div>

            <div class="gallery-grid" id="galleryGrid">
                <!-- Use existing site images; add category badges (operations, events, awards, facilities) -->
                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/gallery-1.jpg')); ?>"
                    data-caption="Recycling operations - Plant view" data-category="operations"
                    data-title="Recycling operations - Plant view"
                    data-desc="Overview of our recycling plant operations showing processing lines and material flow.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/gallery-1.jpg')); ?>" alt="Recycling operations - Plant view" />
                        <figcaption class="item-caption">
                            <span class="title">Recycling operations - Plant view</span><span
                                class="item-badge">Operations</span>
                        </figcaption>
                    </figure>
                </div>

                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/gallery-2.jpg')); ?>"
                    data-caption="Material handling" data-category="operations" data-title="Material handling"
                    data-desc="Equipment and crews engaged in safe material handling and logistics at our site.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/gallery-2.jpg')); ?>" alt="Material handling" />
                        <figcaption class="item-caption">
                            <span class="title">Material handling</span><span class="item-badge">Operations</span>
                        </figcaption>
                    </figure>
                </div>

                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/slide1.jpeg')); ?>"
                    data-caption="Processing unit" data-category="facilities" data-title="Processing unit"
                    data-desc="High-capacity processing lines and modern machinery in our facilities.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/slide1.jpeg')); ?>" alt="Processing unit" />
                        <figcaption class="item-caption">
                            <span class="title">Processing unit</span><span class="item-badge">Facilities</span>
                        </figcaption>
                    </figure>
                </div>

                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/event-img.png')); ?>"
                    data-caption="Company event" data-category="events" data-title="Company event"
                    data-desc="Highlights from a recent company event celebrating milestones and team achievements.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/event-img.png')); ?>" alt="Company event" />
                        <figcaption class="item-caption">
                            <span class="title">Company event</span><span class="item-badge">Events</span>
                        </figcaption>
                    </figure>
                </div>

                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/our-legacy-bg-img1.jpg')); ?>"
                    data-caption="Our legacy" data-category="operations" data-title="Our legacy"
                    data-desc="A look back at the legacy and heritage that shaped EEYA Metal's journey.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/our-legacy-bg-img1.jpg')); ?>" alt="Our legacy" />
                        <figcaption class="item-caption">
                            <span class="title">Our legacy</span><span class="item-badge">Operations</span>
                        </figcaption>
                    </figure>
                </div>

                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/Award-BG-Banneer.webp')); ?>"
                    data-caption="Awards & achievements" data-category="awards" data-title="Awards & achievements"
                    data-desc="Recognitions and awards received for excellence in manufacturing and sustainability.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/Award-BG-Banneer.webp')); ?>" alt="Awards & achievements" />
                        <figcaption class="item-caption">
                            <span class="title">Awards & achievements</span><span class="item-badge">Awards</span>
                        </figcaption>
                    </figure>
                </div>

                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/awards-img-1.jpg')); ?>"
                    data-caption="Award image 1" data-category="awards" data-title="Award image 1"
                    data-desc="Award ceremony photo highlighting our team's achievement.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/awards-img-1.jpg')); ?>" alt="Award image 1" />
                        <figcaption class="item-caption">
                            <span class="title">Award image 1</span><span class="item-badge">Awards</span>
                        </figcaption>
                    </figure>
                </div>

                <div class="gallery-item" tabindex="0" data-full="<?php echo e(asset('assets/images/awards-img-2.jpg')); ?>"
                    data-caption="Award image 2" data-category="awards" data-title="Award image 2"
                    data-desc="Another moment from our recent awards and recognitions.">
                    <figure>
                        <img src="<?php echo e(asset('assets/images/awards-img-2.jpg')); ?>" alt="Award image 2" />
                        <figcaption class="item-caption">
                            <span class="title">Award image 2</span><span class="item-badge">Awards</span>
                        </figcaption>
                    </figure>
                </div>
            </div>
        </div>
    </section>

    <!-- Lightbox overlay -->
    <div id="lightbox" class="lb-overlay" aria-hidden="true" role="dialog" aria-label="Image preview">
        <button class="lb-close" aria-label="Close lightbox">&times;</button>
        <div class="lb-nav">
            <button class="lb-prev" aria-label="Previous image">‹</button>
            <button class="lb-next" aria-label="Next image">›</button>
        </div>
        <img src="" alt="" class="lb-image" />
        <div class="lb-info">
            <h3 id="lbTitle"></h3>
            <div id="lbDesc" class="lb-desc"></div>
            <div class="lb-caption" id="lbCaption"></div>
        </div>
    </div>
    <?php $__env->startPush('scripts'); ?>
        <script>
            (function() {
                var gallery = document.getElementById("galleryGrid");
                var lightbox = document.getElementById("lightbox");
                var lbImage = lightbox.querySelector(".lb-image");
                var lbTitle = document.getElementById("lbTitle");
                var lbDesc = document.getElementById("lbDesc");
                var lbCaption = document.getElementById("lbCaption");
                var lbClose = lightbox.querySelector(".lb-close");
                var lbPrev = lightbox.querySelector(".lb-prev");
                var lbNext = lightbox.querySelector(".lb-next");

                // category filter buttons
                var filterButtons = Array.from(
                    document.querySelectorAll(".category-btn")
                );

                function applyFilter(filter) {
                    var items = Array.from(document.querySelectorAll(".gallery-item"));
                    items.forEach(function(it) {
                        var cat = (it.getAttribute("data-category") || "").toLowerCase();
                        if (filter === "all" || cat === filter) {
                            it.style.display = "";
                            it.setAttribute("aria-hidden", "false");
                        } else {
                            it.style.display = "none";
                            it.setAttribute("aria-hidden", "true");
                        }
                    });
                }

                // wire up filter buttons
                filterButtons.forEach(function(btn) {
                    btn.addEventListener("click", function() {
                        var filter = (
                            btn.getAttribute("data-filter") || "all"
                        ).toLowerCase();
                        // toggle active state
                        filterButtons.forEach(function(b) {
                            b.classList.remove("active");
                            b.setAttribute("aria-selected", "false");
                        });
                        btn.classList.add("active");
                        btn.setAttribute("aria-selected", "true");
                        applyFilter(filter);
                    });
                });

                // apply initial filter (from the active button or default to 'all')
                (function() {
                    var active = filterButtons.find(function(b) {
                        return b.classList.contains("active");
                    });
                    var start = active ?
                        (active.getAttribute("data-filter") || "all").toLowerCase() :
                        "all";
                    // set aria-selected correctly on load
                    filterButtons.forEach(function(b) {
                        b.setAttribute(
                            "aria-selected",
                            b.classList.contains("active") ? "true" : "false"
                        );
                    });
                    applyFilter(start);
                })();

                // gather items array for navigation
                function getVisibleItems() {
                    return Array.from(document.querySelectorAll(".gallery-item")).filter(
                        function(it) {
                            return it.offsetParent !== null;
                        }
                    );
                }
                var currentIndex = -1;

                // openLightbox now accepts the .gallery-item element and populates richer details
                function openLightbox(item) {
                    if (!item) return;
                    var src =
                        item.getAttribute("data-full") ||
                        (item.querySelector("img") && item.querySelector("img").src) ||
                        "";
                    var caption = item.getAttribute("data-caption") || "";
                    var title =
                        item.getAttribute("data-title") ||
                        caption ||
                        (item.querySelector("img") && item.querySelector("img").alt) ||
                        "";
                    var desc = item.getAttribute("data-desc") || "";

                    lbImage.src = src;
                    lbImage.alt = title || "";
                    // populate details
                    if (lbTitle) lbTitle.textContent = title;
                    if (lbDesc) lbDesc.textContent = desc;
                    if (lbCaption) lbCaption.textContent = caption;

                    lightbox.classList.add("open");
                    lightbox.setAttribute("aria-hidden", "false");
                    // lock scroll
                    document.body.style.overflow = "hidden";
                    lbClose.focus();
                }

                function openByIndex(i) {
                    var items = getVisibleItems();
                    if (i < 0 || i >= items.length) return;
                    var it = items[i];
                    currentIndex = i;
                    openLightbox(it);
                }

                function showNext(dir) {
                    var items = getVisibleItems();
                    if (items.length === 0) return;
                    var next = currentIndex + dir;
                    if (next < 0) next = items.length - 1;
                    if (next >= items.length) next = 0;
                    openByIndex(next);
                }

                function closeLightbox() {
                    lightbox.classList.remove("open");
                    lightbox.setAttribute("aria-hidden", "true");
                    lbImage.src = "";
                    document.body.style.overflow = "";
                }

                gallery.addEventListener("click", function(e) {
                    var item = e.target.closest(".gallery-item");
                    if (!item) return;
                    // compute current index among visible items then open
                    var visible = getVisibleItems();
                    currentIndex = visible.indexOf(item);
                    openLightbox(item);
                });

                // keyboard + close handlers
                lbClose.addEventListener("click", closeLightbox);
                lightbox.addEventListener("click", function(e) {
                    if (e.target === lightbox) closeLightbox();
                });
                document.addEventListener("keydown", function(e) {
                    if (e.key === "Escape" && lightbox.classList.contains("open"))
                        closeLightbox();
                });

                // allow keyboard activation on focused gallery items
                gallery.addEventListener("keydown", function(e) {
                    if (e.key === "Enter" || e.key === " ") {
                        var item = e.target.closest(".gallery-item");
                        if (item) {
                            e.preventDefault();
                            var visible = getVisibleItems();
                            currentIndex = visible.indexOf(item);
                            openLightbox(item);
                        }
                    }
                });

                // lightbox prev/next handlers
                if (lbPrev)
                    lbPrev.addEventListener("click", function() {
                        showNext(-1);
                    });
                if (lbNext)
                    lbNext.addEventListener("click", function() {
                        showNext(1);
                    });

                // keyboard navigation inside lightbox
                document.addEventListener("keydown", function(e) {
                    if (lightbox.classList.contains("open")) {
                        if (e.key === "ArrowRight") {
                            e.preventDefault();
                            showNext(1);
                        }
                        if (e.key === "ArrowLeft") {
                            e.preventDefault();
                            showNext(-1);
                        }
                    }
                });

                // AOS-like intersection observer for simple reveal animations
                (function() {
                    var aosElems = Array.from(document.querySelectorAll(".aos"));
                    if (!aosElems.length) return;
                    var io = new IntersectionObserver(
                        function(entries) {
                            entries.forEach(function(en) {
                                if (en.isIntersecting) {
                                    en.target.classList.add("aos-animate");
                                }
                            });
                        }, {
                            threshold: 0.12
                        }
                    );
                    aosElems.forEach(function(el) {
                        io.observe(el);
                    });
                })();

                // Hero slider: 3 slides autoplay every 3s, pause on hover
                (function() {
                    var slider = document.getElementById("heroSlider");
                    if (!slider) return;
                    var slides = Array.from(slider.querySelectorAll(".hero-slide"));
                    if (!slides.length) return;
                    var current = 0;
                    var interval = 3000; // 3 seconds
                    var timer = null;

                    function show(i) {
                        slides.forEach(function(s) {
                            s.classList.remove("active");
                        });
                        var idx = ((i % slides.length) + slides.length) % slides.length;
                        slides[idx].classList.add("active");
                        current = idx;
                    }

                    function start() {
                        if (timer) clearInterval(timer);
                        timer = setInterval(function() {
                            show(current + 1);
                        }, interval);
                    }

                    function stop() {
                        if (timer) {
                            clearInterval(timer);
                            timer = null;
                        }
                    }

                    // start
                    show(0);
                    start();

                    // pause on hover/focus for accessibility
                    slider.addEventListener("mouseenter", stop);
                    slider.addEventListener("mouseleave", start);
                    slider.addEventListener("focusin", stop);
                    slider.addEventListener("focusout", start);
                })();
            })();
        </script>
        <script>
            // Google Translate widget initialization and toggle
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({
                    pageLanguage: 'en',
                    layout: google.translate.TranslateElement.InlineLayout.SIMPLE,
                    autoDisplay: false
                }, 'google_translate_element');
            }

            // Toggle visibility of the translate widget container
            (function() {
                var toggle = document.getElementById('gtToggle');
                var container = document.getElementById('google_translate_element');
                if (!toggle) return;
                toggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    if (!container) return;
                    if (container.style.display === 'block') container.style.display = 'none';
                    else container.style.display = 'block';
                });

                // close widget when clicking outside
                document.addEventListener('click', function(e) {
                    if (!container) return;
                    var wrap = document.getElementById('google_translate_container');
                    if (wrap && !wrap.contains(e.target) && e.target !== toggle) {
                        container.style.display = 'none';
                    }
                });
            })();
        </script>
        <script src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <?php $__env->stopPush(); ?>
</div>
<?php /**PATH E:\eeyametal_project\eeyametal_laravel\resources\views/livewire/gallery-livewire.blade.php ENDPATH**/ ?>