<div>
    @push('styles')
        <link rel="stylesheet" href="{{ asset('assets/css/our-products.css') }}" />
        <style>
            /* Page-specific styling (keeps visual harmony with site bundles) */
            .products-hero {
                color: #fff;
                text-align: center;
                padding: 0;
                position: relative;
            }

            .products-hero h1 {
                font-size: 48px;
                margin: 0 0 8px;
                font-weight: 900;
                text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
                /* position: absolute; */
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                z-index: 2;
            }

            .products-hero p {
                opacity: 0.95;
                max-width: 900px;
                margin: 0 auto;
                font-size: 20px;
            }

            .controls-row {
                display: flex;
                justify-content: space-between;
                align-items: center;
                gap: 12px;
                flex-wrap: wrap;
                margin-bottom: 18px;
            }

            .product-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
                gap: 22px;
                margin: 22px 0;
            }

            .product-card {
                background: #fff;
                border-radius: 10px;
                overflow: hidden;
                box-shadow: 0 8px 26px rgba(16, 24, 40, 0.06);
                display: flex;
                flex-direction: column;
                transition: transform 0.18s ease, box-shadow 0.18s ease;
            }

            .product-card:focus-within,
            .product-card:hover {
                transform: translateY(-6px);
                box-shadow: 0 18px 40px rgba(16, 24, 40, 0.12);
            }

            .product-figure {
                position: relative;
                overflow: hidden;
                height: 200px;
            }

            .product-figure img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                display: block;
                transition: transform 0.35s ease;
            }

            .product-card:hover .product-figure img {
                transform: scale(1.04);
            }

            .card-body {
                padding: 18px;
                flex: 1;
                display: flex;
                flex-direction: column;
            }

            .product-title {
                font-size: 18px;
                font-weight: 700;
                margin-bottom: 6px;
                color: #0b2240;
            }

            .product-desc {
                font-size: 14px;
                color: #5a6776;
                margin-bottom: 12px;
                flex: 1;
            }

            .meta-row {
                display: flex;
                gap: 10px;
                align-items: center;
                font-size: 13px;
                color: #6b7785;
                margin-bottom: 10px;
            }

            .badge-cat {
                background: #eef6ff;
                color: #0b58a6;
                padding: 6px 8px;
                border-radius: 999px;
                font-weight: 600;
                font-size: 12px;
            }

            .actions {
                display: flex;
                gap: 10px;
            }

            .btn-primary {
                background: #003366;
                color: #fff;
                padding: 10px 14px;
                border-radius: 7px;
                text-decoration: none;
                display: inline-block;
            }

            .btn-outline {
                border: 1px solid #d7e2ef;
                color: #0b2b4a;
                padding: 9px 12px;
                border-radius: 7px;
                text-decoration: none;
                background: #fff;
            }

            /* Modal */
            .modal-overlay {
                position: fixed;
                inset: 0;
                background: rgba(3, 6, 23, 0.72);
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 24px;
                z-index: 9999;
                visibility: hidden;
                opacity: 0;
                transition: opacity 0.15s ease, visibility 0.15s;
            }

            .modal-overlay.open {
                visibility: visible;
                opacity: 1;
            }

            .modal-card {
                background: #fff;
                border-radius: 10px;
                max-width: 1000px;
                width: 100%;
                max-height: 90vh;
                overflow: auto;
                display: grid;
                grid-template-columns: 1fr 420px;
            }

            .modal-card img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }

            .modal-body {
                padding: 20px;
            }

            .modal-close {
                position: absolute;
                top: 14px;
                right: 18px;
                background: transparent;
                border: 0;
                color: #fff;
                font-size: 30px;
                cursor: pointer;
            }

            @media (max-width: 900px) {
                .modal-card {
                    grid-template-columns: 1fr;
                    max-height: calc(100vh - 80px);
                }

                .product-figure {
                    height: 160px;
                }
            }

            /* small helpers */
            .sr-only {
                position: absolute;
                width: 1px;
                height: 1px;
                padding: 0;
                margin: -1px;
                overflow: hidden;
                clip: rect(0, 0, 0, 0);
                white-space: nowrap;
                border: 0;
            }

            /* Animations */
            @keyframes slideUp {
                from {
                    transform: translateY(14px);
                    opacity: 0;
                }

                to {
                    transform: translateY(0);
                    opacity: 1;
                }
            }

            @keyframes pulse {
                0% {
                    transform: scale(1);
                }

                50% {
                    transform: scale(1.02);
                }

                100% {
                    transform: scale(1);
                }
            }

            /* reveal on scroll */
            .reveal {
                opacity: 0;
                transform: translateY(18px);
                transition: all 0.6s cubic-bezier(0.2, 0.9, 0.3, 1);
            }

            .reveal.in-view {
                opacity: 1;
                transform: translateY(0);
            }

            /* hero text animation */
            .products-hero h1 {
                animation: slideUp 0.7s ease both;
            }

            .products-hero p {
                animation: slideUp 0.9s ease both;
            }

            /* figure overlay */
            .product-figure {
                position: relative;
            }

            .fig-overlay {
                position: absolute;
                inset: 0;
                display: flex;
                align-items: center;
                justify-content: center;
                background: linear-gradient(180deg,
                        rgba(2, 6, 23, 0) 0%,
                        rgba(2, 6, 23, 0.28) 55%,
                        rgba(2, 6, 23, 0.48) 100%);
                opacity: 0;
                transition: opacity 0.25s ease;
            }

            .product-card:hover .fig-overlay,
            .product-card:focus-within .fig-overlay {
                opacity: 1;
            }

            .fig-overlay .icon {
                background: rgba(255, 255, 255, 0.06);
                backdrop-filter: blur(4px);
                border-radius: 999px;
                padding: 12px;
                display: inline-grid;
                place-items: center;
                border: 1px solid rgba(255, 255, 255, 0.08);
            }

            .fig-overlay .icon svg {
                width: 22px;
                height: 22px;
                fill: #fff;
                transform: translateY(-1px);
            }

            /* modal animation */
            .modal-card {
                transform: translateY(10px) scale(0.99);
                transition: all 0.18s cubic-bezier(0.2, 0.9, 0.3, 1);
            }

            .modal-overlay.open .modal-card {
                transform: translateY(0) scale(1);
            }

            /* subtle button hover */
            .btn-primary:hover {
                animation: pulse 1.2s ease-in-out;
            }

            /* Why-choose section: sticky image + animated overlay + FAQ */
            .why-choose {
                background: #fafafa;
                padding: 56px 0;
            }

            .why-grid {
                display: grid;
                grid-template-columns: 1fr 1fr;
                gap: 28px;
                align-items: start;
            }

            @media (max-width: 900px) {
                .why-grid {
                    grid-template-columns: 1fr;
                }
            }

            .sticky-figure {
                position: relative;
                border-radius: 12px;
                overflow: hidden;
                height: 420px;
            }

            @media (min-width: 900px) {
                .sticky-figure {
                    position: sticky;
                    top: 96px;
                    height: calc(100vh - 200px);
                }
            }

            .sticky-figure img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                display: block;
                filter: brightness(0.66);
                transition: transform 0.6s ease;
            }

            .sticky-overlay {
                position: absolute;
                left: 20px;
                bottom: 20px;
                color: #fff;
                padding: 18px 20px;
                border-radius: 10px;
                backdrop-filter: blur(6px);
                background: linear-gradient(180deg,
                        rgba(2, 6, 23, 0.06),
                        rgba(2, 6, 23, 0.28));
                box-shadow: 0 10px 30px rgba(2, 6, 23, 0.24);
                transition: transform 0.45s cubic-bezier(0.2, 0.9, 0.3, 1),
                    opacity 0.45s;
            }

            .sticky-overlay h3 {
                margin: 0 0 6px;
                font-size: 26px;
                line-height: 1.05;
            }

            .sticky-overlay p {
                margin: 0;
                color: rgba(255, 255, 255, 0.92);
            }

            .sticky-overlay.lift {
                transform: translateY(-22px);
            }

            .why-features {
                padding: 8px 2px;
            }

            .why-features h3 {
                margin-top: 4px;
                margin-bottom: 10px;
            }

            .why-features ul {
                list-style: none;
                padding: 0;
                margin: 0;
            }

            .why-features li {
                display: flex;
                gap: 12px;
                margin-bottom: 12px;
                align-items: flex-start;
            }

            .why-features li .dot {
                width: 10px;
                height: 10px;
                border-radius: 999px;
                background: #0b58a6;
                margin-top: 6px;
                flex: 0 0 10px;
            }

            .cta-row {
                margin-top: 16px;
                display: flex;
                gap: 12px;
                align-items: center;
            }

            /* FAQ */
            .faq-section {
                margin-top: 26px;
            }

            .faq-item {
                border-top: 1px solid #e6eef6;
                padding: 12px 0;
            }

            .faq-question {
                display: flex;
                justify-content: space-between;
                align-items: center;
                gap: 12px;
                cursor: pointer;
            }

            .faq-question h4 {
                margin: 0;
                font-size: 16px;
            }

            .faq-toggle {
                width: 36px;
                height: 36px;
                border-radius: 999px;
                border: 1px solid #d7e2ef;
                background: #fff;
                display: inline-grid;
                place-items: center;
            }

            .faq-answer {
                overflow: hidden;
                max-height: 0;
                opacity: 0;
                transition: max-height 0.34s ease, opacity 0.34s ease;
                padding-top: 0;
            }

            .faq-item.open .faq-answer {
                max-height: 400px;
                opacity: 1;
                padding-top: 12px;
            }

            /* Lower FAQ section styles (answers colored) */
            .faq-lower {
                background: linear-gradient(180deg, #fbfdff 0%, #ffffff 100%);
                padding: 56px 0;
            }

            .faq-lower .faq-wrap {
                max-width: 1100px;
                margin: 0 auto;
                display: grid;
                gap: 18px;
            }

            .faq-lower .faq-card {
                padding: 18px;
                border-radius: 12px;
                background: #fff;
                border: 1px solid #e6f0fb;
                box-shadow: 0 6px 18px rgba(4, 25, 40, 0.03);
                display: block;
            }

            .faq-lower .faq-q {
                font-size: 16px;
                margin: 0;
                color: #042a45;
                cursor: pointer;
            }

            .faq-lower .faq-a {
                margin-top: 10px;
                color: #003366;
                background: rgba(0, 51, 102, 0.05);
                padding: 12px;
                border-radius: 8px;
                border-left: 4px solid rgba(0, 86, 166, 0.12);
            }

            .faq-lower .faq-a small {
                display: block;
                color: #0b3b5b;
                margin-top: 6px;
            }

            @media (max-width: 700px) {
                .faq-lower {
                    padding: 36px 0;
                }
            }
        </style>

        <style>
            /* Hero slider styles */
            .hero-slider {
                /* position: relative; */
                height: 500px;
                max-height: 70vh;
                overflow: hidden;
                /* background: #000; */
            }

            .hero-slide {
                position: absolute;
                inset: 0;
                opacity: 0;
                visibility: hidden;
                transition: opacity 0.8s ease;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .hero-slide img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                display: block;
                filter: brightness(0.8);
            }

            .hero-slide.active {
                opacity: 1;
                visibility: visible;
            }

            .hero-overlay {
                position: absolute;
                left: 0;
                bottom: 0;
                padding: 28px 36px;
                color: #fff;
            }

            .hero-caption h2 {
                font-size: 34px;
                margin: 0 0 6px;
                text-shadow: 0 6px 20px rgba(0, 0, 0, 0.45);
            }

            .hero-caption p {
                margin: 0;
                color: rgba(255, 255, 255, 0.92);
                max-width: 700px;
                text-shadow: 0 6px 20px rgba(0, 0, 0, 0.35);
            }

            .hero-prev,
            .hero-next {
                position: absolute;
                top: 50%;
                transform: translateY(-50%);
                background: rgba(0, 0, 0, 0.36);
                color: #fff;
                border: 0;
                padding: 10px 14px;
                border-radius: 6px;
                cursor: pointer;
                font-size: 22px;
            }

            .hero-prev {
                left: 18px;
            }

            .hero-next {
                right: 18px;
            }

            .hero-dots {
                position: absolute;
                left: 50%;
                transform: translateX(-50%);
                bottom: 12px;
                display: flex;
                gap: 8px;
            }

            .hero-dots button {
                width: 10px;
                height: 10px;
                border-radius: 999px;
                border: 0;
                background: rgba(255, 255, 255, 0.45);
                cursor: pointer;
            }

            .hero-dots button.active {
                background: #fff;
            }

            @media (max-width: 767px) {
                .hero-caption h2 {
                    font-size: 24px;
                }

                .hero-caption p {
                    font-size: 14px;
                }

                .hero-slider {
                    height: 260px;
                }
            }
        </style>
    @endpush

    <section class="products-hero">
        <div class="hero-slider" id="heroSlider" aria-roledescription="carousel">
            <div class="hero-slide" data-index="0">
                <picture>
                    <source srcset="{{ asset('assets/images/gallery-1.jpg') }}" type="image/jpeg" />
                    <img src="{{ asset('assets/images/gallery-1.jpg') }}" alt="EEYA Metal - slide 1" loading="lazy" />
                </picture>
                <div class="hero-overlay">
                    <div class="hero-caption">
                        <h1>Our Products</h1>
                        {{-- <p>
                            Explore EEYA Metal’s core products — sustainable, traceable
                            and engineered to spec.
                        </p> --}}
                    </div>
                </div>
            </div>

            <div class="hero-slide" data-index="1">
                <picture>
                    <source srcset="{{ asset('assets/images/gallery-2.jpg') }}" type="image/jpeg" />
                    <img src="{{ asset('assets/images/gallery-2.jpg') }}" alt="EEYA Metal - slide 2" loading="lazy" />
                </picture>
                <div class="hero-overlay">
                    <div class="hero-caption">
                        <h1>Our Products</h1>
                        {{-- <p>
                            High-quality recycled materials and customised alloy
                            solutions.
                        </p> --}}
                    </div>
                </div>
            </div>

            <div class="hero-slide" data-index="2">
                <picture>
                    <source srcset="{{ asset('assets/images/slide1.jpeg') }}" type="image/jpeg" />
                    <img src="{{ asset('assets/images/slide1.jpeg') }}" alt="EEYA Metal - slide 3" loading="lazy" />
                </picture>
                <div class="hero-overlay">
                    <div class="hero-caption">
                        <h1>Our Products</h1>
                        {{-- <p>Turnkey solutions from consultancy to plant delivery.</p> --}}
                    </div>
                </div>
            </div>

            <button class="hero-prev" aria-label="Previous slide">‹</button>
            <button class="hero-next" aria-label="Next slide">›</button>
            <div class="hero-dots" role="tablist" aria-label="Hero slide indicators"></div>
        </div>
    </section>
    <section class="common-padding">
        <div class="container">
            <div class="controls-row">
                <h2 style="margin: 0">Featured Products</h2>
                <div style="display: flex; gap: 8px; align-items: center">
                    <label for="categoryFilter" class="sr-only">Filter products</label>
                    <select id="categoryFilter" aria-label="Filter products"
                        style="
                  padding: 8px;
                  border-radius: 8px;
                  border: 1px solid #e6eef6;
                ">
                        <option value="all">All categories</option>
                        <option value="lead">Lead</option>
                        <option value="aluminium">Aluminium</option>
                        <option value="plastic">Plastic</option>
                        <option value="turnkey">Turnkey</option>
                    </select>
                </div>
            </div>

            <div class="product-grid" id="productGrid">
                <!-- product card (data-category used for filter) -->
                <article class="product-card reveal" tabindex="0" data-category="lead"
                    data-title="Battery Recycling - Lead"
                    data-desc="High-quality recovered lead for new battery production via sustainable recycling."
                    data-image="{{ asset('assets/images/our-choose-us-img.avif') }}">
                    <figure class="product-figure">
                        <img src="{{ asset('assets/images/our-choose-us-img.avif') }}" alt="Battery Recycling - Lead"
                            loading="lazy" />
                        <div class="fig-overlay" aria-hidden="true">
                            <div class="icon">
                                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                    <path
                                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0016 9.5 6.5 6.5 0 109.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zM10 14a4 4 0 110-8 4 4 0 010 8z" />
                                </svg>
                            </div>
                        </div>
                    </figure>
                    <div class="card-body">
                        <div class="product-title">Metal Recycling - Lead</div>
                        <div class="meta-row">
                            <span class="badge-cat">Lead</span><span>Industrial grade</span>
                        </div>
                        <div class="product-desc">
                            High-quality recovered lead for new metal production via
                            sustainable recycling.
                        </div>
                        <div class="actions">
                            <a class="btn-outline" href="{{ route('metal-lead') }}">Learn more</a>
                        </div>
                    </div>
                </article>

                <article class="product-card reveal" tabindex="0" data-category="aluminium"
                    data-title="Aluminium Alloys"
                    data-desc="Custom aluminium alloys produced from recycled scrap for multiple industries."
                    data-image="{{ asset('assets/images/our-choose-us-img2.avif') }}">
                    <figure class="product-figure">
                        <img src="{{ asset('assets/images/our-choose-us-img2.avif') }}" alt="Aluminium Alloys"
                            loading="lazy" />
                        <div class="fig-overlay" aria-hidden="true">
                            <div class="icon">
                                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0016 9.5 6.5 6.5 0 109.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zM10 14a4 4 0 110-8 4 4 0 010 8z" />
                                </svg>
                            </div>
                        </div>
                    </figure>
                    <div class="card-body">
                        <div class="product-title">Aluminium Alloys</div>
                        <div class="meta-row">
                            <span class="badge-cat">Aluminium</span><span>Custom grades</span>
                        </div>
                        <div class="product-desc">
                            Custom aluminium alloys produced from recycled scrap for
                            multiple industries.
                        </div>
                        <div class="actions">
                            <a class="btn-primary" href="{{ route('aluminius-alloys') }}">Learn more</a>
                        </div>
                    </div>
                </article>

                <article class="product-card reveal" tabindex="0" data-category="plastic"
                    data-title="Plastic Granules"
                    data-desc="Recycled-grade plastic granules suitable for manufacturing and packaging."
                    data-image="{{ asset('assets/images/paision-img.avif') }}">
                    <figure class="product-figure">
                        <img src="{{ asset('assets/images/paision-img.avif') }}" alt="Plastic Granules"
                            loading="lazy" />
                        <div class="fig-overlay" aria-hidden="true">
                            <div class="icon">
                                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0016 9.5 6.5 6.5 0 109.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zM10 14a4 4 0 110-8 4 4 0 010 8z" />
                                </svg>
                            </div>
                        </div>
                    </figure>
                    <div class="card-body">
                        <div class="product-title">Plastic Granules</div>
                        <div class="meta-row">
                            <span class="badge-cat">Plastic</span><span>Recycled granules</span>
                        </div>
                        <div class="product-desc">
                            Recycled-grade plastic granules suitable for manufacturing and
                            packaging.
                        </div>
                        <div class="actions">
                            <a class="btn-primary" href="{{ route('plastic-granules') }}">Learn more</a>
                        </div>
                    </div>
                </article>

                <article class="product-card reveal" tabindex="0" data-category="turnkey"
                    data-title="Turnkey Solutions"
                    data-desc="End-to-end project delivery for recycling plants and equipment."
                    data-image="{{ asset('assets/images/trust-img.avif') }}">
                    <figure class="product-figure">
                        <img src="{{ asset('assets/images/trust-img.avif') }}" alt="Turnkey Solutions"
                            loading="lazy" />
                        <div class="fig-overlay" aria-hidden="true">
                            <div class="icon">
                                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0016 9.5 6.5 6.5 0 109.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zM10 14a4 4 0 110-8 4 4 0 010 8z" />
                                </svg>
                            </div>
                        </div>
                    </figure>
                    <div class="card-body">
                        <div class="product-title">Turnkey Solutions</div>
                        <div class="meta-row">
                            <span class="badge-cat">Turnkey</span><span>Project delivery</span>
                        </div>
                        <div class="product-desc">
                            End-to-end project delivery for recycling plants and
                            equipment.
                        </div>
                        <div class="actions">
                            <a class="btn-primary" href="{{ route('turnkey-solution') }}">Learn more</a>
                        </div>
                    </div>
                </article>
            </div>
        </div>
    </section>

    <section class="why-choose common-padding">
        <div class="container">
            <div class="why-grid">
                <div class="sticky-figure reveal">
                    <img src="{{ asset('assets/images/our-choose-us-img.avif') }}" alt="Why choose Eeya Metal"
                        loading="lazy" />
                    <div class="sticky-overlay" id="whyOverlay" aria-hidden="false">
                        <h3>Why choose our products?</h3>
                        <p>
                            Certified, traceable recycled materials — engineered to spec
                            and delivered with turnkey support.
                        </p>
                    </div>
                </div>

                <div class="why-features">
                    <h3 style="margin-bottom: 6px">What sets EEYA Metal apart</h3>
                    <ul>
                        <li>
                            <span class="dot" aria-hidden="true"></span>
                            <div>
                                <strong>Traceability:</strong> Full material traceability
                                and certification across supply chains.
                            </div>
                        </li>
                        <li>
                            <span class="dot" aria-hidden="true"></span>
                            <div>
                                <strong>Quality & consistency:</strong> Tight process
                                controls to meet exact alloy specifications.
                            </div>
                        </li>
                        <li>
                            <span class="dot" aria-hidden="true"></span>
                            <div>
                                <strong>Sustainability:</strong> High recovery rates and
                                lower environmental footprint.
                            </div>
                        </li>
                        <li>
                            <span class="dot" aria-hidden="true"></span>
                            <div>
                                <strong>Turnkey delivery:</strong> Consultancy to plant
                                delivery & commissioning.
                            </div>
                        </li>
                    </ul>

                    <div class="cta-row">
                        <a class="btn-primary" href="contact-us.html">Request a quote</a>
                        <a class="btn-outline" href="#faqLower">View FAQ</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal for product details -->
    <div id="productModal" class="modal-overlay" aria-hidden="true" role="dialog" aria-modal="true">
        <button class="modal-close" aria-label="Close modal">&times;</button>
        <div class="modal-card" role="document">
            <div class="modal-media"><img src="" alt="" id="modalImage" /></div>
            <div class="modal-body">
                <h3 id="modalTitle"></h3>
                <p id="modalCategory" style="color: #6b7785; margin: 6px 0; font-weight: 600"></p>
                <p id="modalDesc" style="color: #4b5563; line-height: 1.6"></p>
                <div style="margin-top: 16px">
                    <a id="modalLearn" class="btn-outline" href="#">Learn more</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Lower FAQ section: moved down as requested -->
    <section class="faq-lower" id="faqLower" aria-labelledby="faqLowerHeading">
        <div class="container">
            <div class="faq-wrap">
                <h2 id="faqLowerHeading" style="margin: 0 0 6px; color: #043259">
                    Frequently asked questions
                </h2>
                <p style="margin: 0 0 14px; color: #566f85">
                    Answers highlighted for quick reading. Click a question to toggle
                    the answer.
                </p>

                <div class="faq-card" data-index="1">
                    <div class="faq-q">What is EEYA Metal's core business?</div>
                    <div class="faq-a">
                        EEYA Metal specialises in recycling and producing alloys (lead,
                        aluminium) and providing turnkey solutions for recycling plants,
                        focusing on traceability and sustainable practices.
                    </div>
                </div>

                <div class="faq-card" data-index="2">
                    <div class="faq-q">How do you ensure material quality?</div>
                    <div class="faq-a">
                        Quality is ensured through incoming material inspection,
                        controlled processing, lab testing and batch-level documentation
                        to meet requested alloy specifications.
                    </div>
                </div>

                <div class="faq-card" data-index="3">
                    <div class="faq-q">
                        Do you provide consultancy and plant delivery?
                    </div>
                    <div class="faq-a">
                        Yes — our turnkey services include feasibility, design,
                        equipment supply, installation and commissioning so you can
                        start operations reliably.
                    </div>
                </div>

                <div class="faq-card" data-index="4">
                    <div class="faq-q">How can I request a sample or quote?</div>
                    <div class="faq-a">
                        Use the Request a quote button or contact our sales team — we'll
                        provide specifications, pricing and sample availability based on
                        your requirements.
                    </div>
                </div>

                <div class="faq-card" data-index="5">
                    <div class="faq-q">
                        Are your products environmentally certified?
                    </div>
                    <div class="faq-a">
                        We follow industry best practices for recycling and provide
                        documentation on recovery rates and process controls; contact us
                        for product-specific certificates.
                    </div>
                </div>
            </div>
        </div>
    </section>
    @push('scripts')
        <script>
            (function() {
                var slider = document.getElementById("heroSlider");
                if (!slider) return;
                var slides = Array.from(slider.querySelectorAll(".hero-slide"));
                var prevBtn = slider.querySelector(".hero-prev");
                var nextBtn = slider.querySelector(".hero-next");
                var dotsWrap = slider.querySelector(".hero-dots");
                var current = 0;
                var interval = 3000;
                var timer = null;

                function goTo(index) {
                    slides.forEach(function(s, i) {
                        s.classList.toggle("active", i === index);
                    });
                    Array.from(dotsWrap.children).forEach(function(b, i) {
                        b.classList.toggle("active", i === index);
                    });
                    current = index;
                }

                // build dots
                slides.forEach(function(_, i) {
                    var b = document.createElement("button");
                    b.setAttribute("aria-label", "Go to slide " + (i + 1));
                    b.addEventListener("click", function() {
                        goTo(i);
                        reset();
                    });
                    dotsWrap.appendChild(b);
                });

                prevBtn.addEventListener("click", function() {
                    goTo((current - 1 + slides.length) % slides.length);
                    reset();
                });
                nextBtn.addEventListener("click", function() {
                    goTo((current + 1) % slides.length);
                    reset();
                });

                function auto() {
                    timer = setInterval(function() {
                        goTo((current + 1) % slides.length);
                    }, interval);
                }

                function reset() {
                    clearInterval(timer);
                    auto();
                }

                slider.addEventListener("mouseenter", function() {
                    clearInterval(timer);
                });
                slider.addEventListener("mouseleave", function() {
                    reset();
                });

                // init
                goTo(0);
                auto();
            })();
        </script>
        <script>
            (function() {
                // Filter products by category
                var filter = document.getElementById("categoryFilter");
                var grid = document.getElementById("productGrid");
                var cards = Array.from(grid.querySelectorAll(".product-card"));

                function applyFilter() {
                    var val = filter.value;
                    cards.forEach(function(card) {
                        if (val === "all" || card.getAttribute("data-category") === val) {
                            card.style.display = "";
                            // trigger reveal when shown
                            requestAnimationFrame(function() {
                                card.classList.add("in-view");
                            });
                        } else {
                            card.style.display = "none";
                        }
                    });
                }
                filter.addEventListener("change", applyFilter);

                // IntersectionObserver for reveal animations
                var io = new IntersectionObserver(
                    function(entries) {
                        entries.forEach(function(ent) {
                            if (ent.isIntersecting) {
                                ent.target.classList.add("in-view");
                                io.unobserve(ent.target);
                            }
                        });
                    }, {
                        threshold: 0.12
                    }
                );
                document.querySelectorAll(".reveal").forEach(function(el) {
                    io.observe(el);
                });

                // Modal wiring
                var modal = document.getElementById("productModal");
                var modalImage = document.getElementById("modalImage");
                var modalTitle = document.getElementById("modalTitle");
                var modalDesc = document.getElementById("modalDesc");
                var modalCategory = document.getElementById("modalCategory");
                var modalLearn = document.getElementById("modalLearn");
                var modalClose = modal.querySelector(".modal-close");

                function openModalFromCard(card) {
                    var title = card.getAttribute("data-title") || "";
                    var desc = card.getAttribute("data-desc") || "";
                    var img = card.getAttribute("data-image") || "";
                    var cat = card.getAttribute("data-category") || "";
                    // find learn more href if exists
                    var learn = card.querySelector(".btn-outline");
                    modalTitle.textContent = title;
                    modalDesc.textContent = desc;
                    modalCategory.textContent =
                        cat.charAt(0).toUpperCase() + cat.slice(1);
                    modalImage.src = img;
                    modalImage.alt = title;
                    modalLearn.href = learn ? learn.getAttribute("href") : "#";

                    modal.classList.add("open");
                    modal.setAttribute("aria-hidden", "false");
                    // trap focus briefly
                    modalClose.focus();
                    document.body.style.overflow = "hidden";
                }

                function closeModal() {
                    modal.classList.remove("open");
                    modal.setAttribute("aria-hidden", "true");
                    modalImage.src = "";
                    document.body.style.overflow = "";
                }

                // open when clicking product-open or pressing Enter on card
                grid.addEventListener("click", function(e) {
                    var btn = e.target.closest(".product-open");
                    if (btn) {
                        e.preventDefault();
                        var card = btn.closest(".product-card");
                        openModalFromCard(card);
                    }
                });

                grid.addEventListener("keydown", function(e) {
                    if (e.key === "Enter" || e.key === " ") {
                        var card = e.target.closest(".product-card");
                        if (card) {
                            e.preventDefault();
                            openModalFromCard(card);
                        }
                    }
                });

                modalClose.addEventListener("click", closeModal);
                modal.addEventListener("click", function(e) {
                    if (e.target === modal) closeModal();
                });
                document.addEventListener("keydown", function(e) {
                    if (e.key === "Escape" && modal.classList.contains("open"))
                        closeModal();
                });

                // initial filter application (show all)
                applyFilter();
            })();
        </script>
        <script>
            (function() {
                // FAQ accordion behavior and overlay lift on scroll
                var faqItems = Array.from(document.querySelectorAll(".faq-item"));
                faqItems.forEach(function(item) {
                    var q = item.querySelector(".faq-question");

                    function toggle() {
                        var open = item.classList.toggle("open");
                        q.setAttribute("aria-expanded", open ? "true" : "false");
                        var toggleEl = q.querySelector(".faq-toggle");
                        if (toggleEl) toggleEl.textContent = open ? "−" : "+";
                    }
                    q.addEventListener("click", toggle);
                    q.addEventListener("keydown", function(e) {
                        if (e.key === "Enter" || e.key === " ") {
                            e.preventDefault();
                            toggle();
                        }
                    });
                });

                // Lift overlay a bit when the why-choose section is visible
                var overlay = document.getElementById("whyOverlay");
                var whySection = overlay ? overlay.closest(".why-choose") : null;
                if (whySection && overlay) {
                    var oi = new IntersectionObserver(
                        function(entries) {
                            entries.forEach(function(ent) {
                                if (ent.isIntersecting) {
                                    overlay.classList.add("lift");
                                } else {
                                    overlay.classList.remove("lift");
                                }
                            });
                        }, {
                            threshold: [0, 0.25, 0.6]
                        }
                    );
                    oi.observe(whySection);
                }

                // Small enhancement: hover image scale when overlay lifts
                var stickyFigure = document.querySelector(".sticky-figure");
                if (stickyFigure && overlay) {
                    var io2 = new IntersectionObserver(
                        function(entries) {
                            entries.forEach(function(ent) {
                                if (ent.isIntersecting) {
                                    stickyFigure.querySelector("img").style.transform =
                                        "scale(1.04)";
                                } else {
                                    stickyFigure.querySelector("img").style.transform =
                                        "scale(1)";
                                }
                            });
                        }, {
                            threshold: 0.12
                        }
                    );
                    io2.observe(stickyFigure);
                }

                // Lower FAQ cards toggle (colored answers)
                var lowerFaqCards = Array.from(
                    document.querySelectorAll(".faq-lower .faq-card")
                );
                lowerFaqCards.forEach(function(card) {
                    var q = card.querySelector(".faq-q");
                    var a = card.querySelector(".faq-a");
                    // start collapsed
                    a.style.display = "none";
                    q.setAttribute("tabindex", "0");
                    q.setAttribute("role", "button");
                    q.setAttribute("aria-expanded", "false");
                    q.addEventListener("click", function() {
                        var opened = a.style.display === "block";
                        if (opened) {
                            a.style.display = "none";
                            q.setAttribute("aria-expanded", "false");
                        } else {
                            a.style.display = "block";
                            q.setAttribute("aria-expanded", "true");
                        }
                    });
                    q.addEventListener("keydown", function(e) {
                        if (e.key === "Enter" || e.key === " ") {
                            e.preventDefault();
                            q.click();
                        }
                    });
                });
            })();
        </script>
    @endpush
</div>
