<div>
    @push('styles')
      <link rel="stylesheet" href="{{asset('assets/css/tabscroller-style.css')}}" />
         <link rel="stylesheet" href="{{asset('assets/css/contactus.css')}}" />
    @endpush
    <!-- Contact / Inner banner -->
<section class="innerbanner-section bannerWrapper">
  <div class="bgWrapper">
    <figure>
      <picture>
        <!-- prefer webp first, then jpeg fallback -->
        <source media="(min-width:768px)" srcset="{{asset('assets/images/contact-us-img.jpg')}}" type="image/webp">
        <source media="(max-width:767px)" srcset="{{asset('assets/images/contact-us-img.jpg')}}" type="image/webp">
        <source srcset="{{asset('assets/images/contact-us-img.jpg')}}" type="image/jpeg">
        <img src="{{asset('assets/images/contact-us-img.jpg')}}"
             class="img-fluid lazyload banner_thumbnail"
             alt="Contact us — EEYAMETAL"
             title="Contact us"
             loading="lazy">
      </picture>
      <span class="overlay" aria-hidden="true"></span>
    </figure>
  </div>

  <div class="bgWrapper_titleWrap">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <div class="bgWrapper_title">
            <h1>Contact us</h1>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- <nav aria-label="breadcrumb" class="breadcrumb_container">
    <div class="container">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Contact us</li>
      </ol>
    </div>
  </nav> --}}

  <div class="parallax-icon parallax-icon-innerbanner2 parallax_scroll animation-element slide-left animation-delay1_5" aria-hidden="true">
    <img src="{{asset('assets/images/element-top2.svg')}}" alt="" />
  </div>
</section>

<!-- Contact main -->
<section class="contactus-main-container">
  <div class="bgWrapper-img">
    <img src="{{asset('assets/images/element-top2.svg')}}" class="img-fluid" alt="" loading="lazy" />
  </div>

  <div class="container-fluid p-0">
    <div class="contactus-offices-section">
      <div class="container">
        <div class="row g-0">
          <div class="col-md-6 col-lg-5 col-xl-4">
            <div class="offices-content-wrap animation-element fadein-down">
              <div class="offices-content-title">Corporate Office</div>
              <hr>
              <div class="offices-content-address">
                <p><span class="subTitel">EEYAMETAL India</span><br />
                  APIIC Industrial Park, Thadipatri, Thadipatri (Vill),
                  Tirupati (Dist), Andhra Pradesh<br />
                  <strong>Pin Code</strong> - 517642
                </p>
                <div class="offices-contact">
                  <p><img src="{{asset('assets/images/telephone-icon.svg')}}" alt="Telephone" /> TEL : +91-9973495556</p>
                  <p><img src="{{asset('assets/images/email-icon.svg')}}" alt="Email" /> Email :
                    <a href="mailto:info@eeyametal.co.in">info@eeyametal.co.in</a>
                  </p>
                </div>
                <div class="getDirections-wrap">
                  <a href="https://www.google.com/maps/place/EEYA+METAL+%26+ALLOYS+PVT.+LTD./@13.7692825,79.7617688,17z" target="_blank" rel="noopener noreferrer">
                    Get Directions <span><img src="{{asset('assets/images/pin-icon.svg')}}" alt="" /></span>
                  </a>
                </div>
              </div>
            </div>
          </div>

          <div class="col-md-6 col-lg-5 col-xl-4">
            <div class="offices-content-wrap animation-element fadein-down">
              <div class="offices-content-title">Registered Office</div>
              <hr>
              <div class="offices-content-address">
                <p><span class="subTitel">EEYAMETAL India</span><br />
                  APIIC Industrial Park, Thadipatri, Thadipatri (Vill),
                  Tirupati (Dist), Andhra Pradesh<br />
                  <strong>Pin Code</strong> - 517642
                </p>
                <div class="offices-contact">
                  <p><img src="{{asset('assets/images/telephone-icon.svg')}}" alt="Telephone" /> TEL : +91-9973495556</p>
                  <p><img src="{{asset('assets/images/email-icon.svg')}}" alt="Email" /> Email :
                    <a href="mailto:info@eeyametal.co.in">info@eeyametal.co.in</a>
                  </p>
                </div>
                <div class="getDirections-wrap">
                  <a href="https://www.google.com/maps/place/EEYA+METAL+%26+ALLOYS+PVT.+LTD./@13.7692825,79.7617688,17z" target="_blank" rel="noopener noreferrer">
                    Get Directions <span><img src="{{asset('assets/images/pin-icon.svg')}}" alt="" /></span>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div> <!-- .row -->
      </div> <!-- .container -->
    </div> <!-- .contactus-offices-section -->

    <!-- Get in touch (form + business verticals) -->
    <div class="contactus-getintouch-section parallax-section">
      <div class="parallax-image">
        <img src="{{asset('assets/images/Get_in_touch_BG.webp')}}" class="img-fluid" alt="" loading="lazy" />
      </div>

      <div class="parallax-content">
        <div class="container">
          <div class="row">
            <!-- Left: Form -->
            <div class="col-md-12 col-lg-7">
              <div class="common-title-wrap">
                <h2 class="animation-element slide-left">Get in touch</h2>
              </div>

              <!-- IMPORTANT: form tag added -->
              <form id="contactForm" class="contactForm-container form-div animation-element fadein-down" method="post" action="/contact/submit" novalidate>
                <div class="row">
                  <div class="fieldsInfo">
                    <p>* for compulsory fields</p>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="txtFullName" class="hide_label f-medium">Full Name <sup>*</sup></label>
                      <input id="txtFullName" name="full_name" class="form-control" maxlength="200" placeholder="Full name" type="text" required />
                      <span id="span_full_name" class="field-validation-valid field-validation-error" data-valmsg-for="full_name" data-valmsg-replace="true"></span>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group phone">
                      <label for="txtContact" class="hide_label f-medium">Contact number <sup>*</sup></label>
                      <input id="txtContact" name="phoneNo" class="form-control" placeholder="Contact number" type="tel" maxlength="10" pattern=\"[0-9]{10}\" required />
                      <small class="form-hint">Enter 10 digit phone number</small>
                      <span id="span_phoneNo" class="field-validation-valid field-validation-error" data-valmsg-for="phoneNo" data-valmsg-replace="true"></span>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="txtEmail" class="hide_label f-medium">Email ID <sup>*</sup></label>
                      <input id="txtEmail" name="email_id" class="form-control" maxlength="200" placeholder="E-mail Id" type="email" required />
                      <span id="span_email" class="field-validation-valid field-validation-error" data-valmsg-for="email_id" data-valmsg-replace="true"></span>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="ddlcountry" class="hide_label f-medium">Country <sup>*</sup></label>
                      <select id="ddlcountry" name="country_id" class="form-control form-select contact-select" required>
                        <option value="">Select country</option>
                        <!-- keep your long list of country options here -->
                        <option value="78">India</option>
                        <option value="122">Nepal</option>
                        <!-- ... -->
                      </select>
                      <span id="span_country" class="field-validation-valid field-validation-error" data-valmsg-for="country_id" data-valmsg-replace="true"></span>
                      <input id="hdnCountry" name="country_name" type="hidden" value="" />
                      <input id="hdnCountryEmailId" name="country_email_id" type="hidden" value="" />
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="txtOrganization" class="hide_label f-medium">Organization <sup>*</sup></label>
                      <input id="txtOrganization" name="Organization" class="form-control" maxlength="200" placeholder="Organization" type="text" required />
                      <span id="span_Organization" class="field-validation-valid field-validation-error" data-valmsg-for="Organization" data-valmsg-replace="true"></span>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="ddlcategory" class="hide_label f-medium">Select Type <sup>*</sup></label>
                      <select id="ddlcategory" name="Category_ID" class="form-control form-select contact-select" required>
                        <option value="">Select type</option>
                        <option value="1">Buyer</option>
                        <option value="2">Seller</option>
                        <option value="3">Media</option>
                        <option value="4">Investor</option>
                        <option value="5">Finance</option>
                        <option value="6">Others</option>
                      </select>
                      <span id="span_category" class="field-validation-valid field-validation-error" data-valmsg-for="Category_ID" data-valmsg-replace="true"></span>
                      <input id="hdnCategory" name="category_name" type="hidden" value="" />
                      <input id="hdnCategoryEmailId" name="category_mail_id" type="hidden" value="" />
                    </div>
                  </div>

                  <div class="col-md-12">
                    <div class="form-group form-text">
                      <label for="efMessage" class="hide_label f-medium">Message</label>
                      <textarea id="efMessage" name="message" class="form-control input-style" maxlength="500" placeholder="Type your query here..." rows="4"></textarea>
                    </div>
                  </div>

                  <div class="col-md-12">
                    <div class="contact-policy-wrap">
                      <div class="row">
                        <div class="col-lg-6">
                          <div class="form-check">
                            <input class="form-check-input" id="flexCheckDefault" type="checkbox" required />
                            <label class="form-check-label" for="flexCheckDefault">
                              By using this form you agree with the storage and handling of your data by this website in accordance with our Privacy Policy.
                            </label>
                          </div>
                          <span id="span_agree" class="field-validation-valid field-validation-error" data-valmsg-for="flexCheckDefault" data-valmsg-replace="true"></span>
                        </div>

                        <div class="col-lg-6">
                          <div class="captcha" id="captcha">
                            <!-- reCAPTCHA element (ensure you include the reCAPTCHA script before closing body) -->
                            <div id="recaptcha" class="g-recaptcha" data-callback="captcha_callback" data-sitekey="6LcEAMsoAAAAAEOzo4E9RGdKnU6rrdwtiAagdOWk"></div>
                            <input type="hidden" id="hdnCapcha" name="g-recaptcha-response" />
                            <span id="span_capcha" class="field-validation-valid field-validation-error" data-valmsg-for="recaptcha" data-valmsg-replace="true"></span>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="contactBtn-wrap" style="margin-top:18px;">
                      <span class="circle" aria-hidden="true"><span class="icon arrow"></span></span>
                      <button type="submit" id="btnSave" class="common-btn">Submit</button>
                      <p id="lblmessage" class="submit-message" aria-live="polite"></p>
                    </div>
                  </div>
                </div>
              </form>
              <!-- /form -->
            </div>

            <!-- Right: Business verticals -->
            <div class="col-md-12 col-lg-5">
              <div class="businessVerticals_wrap">
                <div class="businessVerticals_wrapInner animation-element fadein-down">
                  <div class="common-title-wrap">
                    <h2 class="text-white">Business Verticals</h2>
                    <p><span class="notetxt">*Select your business vertical to find the address and contact details of the concerned department.</span></p>

                    <div class="form-div">
                      <div class="form-group">
                        <label for="ddlBusiness" class="hide_label f-medium">Select Business</label>
                        <select id="ddlBusiness" class="form-control form-select contact-select">
                          <option value="lead">Lead &amp; Lead Products</option>
                          <option value="aluminium">Aluminium Alloys</option>
                          <option value="turnkey">Turnkey Solutions</option>
                          <option value="scrap">Scrap Material Procurement (Domestic &amp; International)</option>
                          <option value="epr">EPR &amp; Recycling Solutions</option>
                          <option value="media">Media &amp; Communications</option>
                          <option value="tyre">Recycled Tyre Products</option>
                          <option value="investor">Investor Relations</option>
                          <option value="whistleblower">Whistleblower Reporting</option>
                          <option value="plastic">Plastic Granules &amp; Recycled Plastics</option>
                        </select>
                      </div>
                    </div>

                    <div id="divBusiness">
                      <h3>Lead &amp; Lead Products</h3>
                      <div class="businessVerticals-contact">
                        <p><img src="{{asset('assets/images/telephone-icon-white.svg')}}" alt="Phone" /> +91-98765-43210</p>
                        <p><img src="{{asset('assets/images/email-icon-white.svg')}}" alt="Email" /> <a href="mailto:info@eeyametal.com">info@eeyametal.com</a></p>
                        <p>APIIC Industrial Park, Thadipatri, Thadipatri (Vill), Tirupati (Dist) , Andhra Pradesh - 517642</p>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div> <!-- /right column -->
          </div> <!-- /row -->
        </div> <!-- /container -->
      </div> <!-- /parallax-content -->
    </div> <!-- /contactus-getintouch-section -->
  </div> <!-- /container-fluid -->

  <div class="parallax-icon parallax-icon-contactus parallax_scroll animation-element slide-left animation-delay1_5" aria-hidden="true">
    <img src="{{asset('Upload/Images/element_contactus.svg')}}" alt="" loading="lazy" />
  </div>
</section>

    @push('scripts')
        
    @endpush
</div>
