 (function () {
          var slider = document.getElementById("heroSlider");
          if (!slider) return;
          var slides = Array.from(slider.querySelectorAll(".hero-slide"));
          var prevBtn = slider.querySelector(".hero-prev");
          var nextBtn = slider.querySelector(".hero-next");
          var dotsWrap = slider.querySelector(".hero-dots");
          var current = 0;
          var interval = 3000;
          var timer = null;

          function goTo(index) {
            slides.forEach(function (s, i) {
              s.classList.toggle("active", i === index);
            });
            Array.from(dotsWrap.children).forEach(function (b, i) {
              b.classList.toggle("active", i === index);
            });
            current = index;
          }

          // build dots
          slides.forEach(function (_, i) {
            var b = document.createElement("button");
            b.setAttribute("aria-label", "Go to slide " + (i + 1));
            b.addEventListener("click", function () {
              goTo(i);
              reset();
            });
            dotsWrap.appendChild(b);
          });

          prevBtn.addEventListener("click", function () {
            goTo((current - 1 + slides.length) % slides.length);
            reset();
          });
          nextBtn.addEventListener("click", function () {
            goTo((current + 1) % slides.length);
            reset();
          });

          function auto() {
            timer = setInterval(function () {
              goTo((current + 1) % slides.length);
            }, interval);
          }
          function reset() {
            clearInterval(timer);
            auto();
          }

          slider.addEventListener("mouseenter", function () {
            clearInterval(timer);
          });
          slider.addEventListener("mouseleave", function () {
            reset();
          });

          // init
          goTo(0);
          auto();
        })();





        // page scripts: filtering, modal, animated reveals 
    
      (function () {
        // Filter products by category
        var filter = document.getElementById("categoryFilter");
        var grid = document.getElementById("productGrid");
        var cards = Array.from(grid.querySelectorAll(".product-card"));

        function applyFilter() {
          var val = filter.value;
          cards.forEach(function (card) {
            if (val === "all" || card.getAttribute("data-category") === val) {
              card.style.display = "";
              // trigger reveal when shown
              requestAnimationFrame(function () {
                card.classList.add("in-view");
              });
            } else {
              card.style.display = "none";
            }
          });
        }
        filter.addEventListener("change", applyFilter);

        // IntersectionObserver for reveal animations
        var io = new IntersectionObserver(
          function (entries) {
            entries.forEach(function (ent) {
              if (ent.isIntersecting) {
                ent.target.classList.add("in-view");
                io.unobserve(ent.target);
              }
            });
          },
          { threshold: 0.12 }
        );
        document.querySelectorAll(".reveal").forEach(function (el) {
          io.observe(el);
        });

        // Modal wiring
        var modal = document.getElementById("productModal");
        var modalImage = document.getElementById("modalImage");
        var modalTitle = document.getElementById("modalTitle");
        var modalDesc = document.getElementById("modalDesc");
        var modalCategory = document.getElementById("modalCategory");
        var modalLearn = document.getElementById("modalLearn");
        var modalClose = modal.querySelector(".modal-close");

        function openModalFromCard(card) {
          var title = card.getAttribute("data-title") || "";
          var desc = card.getAttribute("data-desc") || "";
          var img = card.getAttribute("data-image") || "";
          var cat = card.getAttribute("data-category") || "";
          // find learn more href if exists
          var learn = card.querySelector(".btn-outline");
          modalTitle.textContent = title;
          modalDesc.textContent = desc;
          modalCategory.textContent =
            cat.charAt(0).toUpperCase() + cat.slice(1);
          modalImage.src = img;
          modalImage.alt = title;
          modalLearn.href = learn ? learn.getAttribute("href") : "#";

          modal.classList.add("open");
          modal.setAttribute("aria-hidden", "false");
          // trap focus briefly
          modalClose.focus();
          document.body.style.overflow = "hidden";
        }

        function closeModal() {
          modal.classList.remove("open");
          modal.setAttribute("aria-hidden", "true");
          modalImage.src = "";
          document.body.style.overflow = "";
        }

        // open when clicking product-open or pressing Enter on card
        grid.addEventListener("click", function (e) {
          var btn = e.target.closest(".product-open");
          if (btn) {
            e.preventDefault();
            var card = btn.closest(".product-card");
            openModalFromCard(card);
          }
        });

        grid.addEventListener("keydown", function (e) {
          if (e.key === "Enter" || e.key === " ") {
            var card = e.target.closest(".product-card");
            if (card) {
              e.preventDefault();
              openModalFromCard(card);
            }
          }
        });

        modalClose.addEventListener("click", closeModal);
        modal.addEventListener("click", function (e) {
          if (e.target === modal) closeModal();
        });
        document.addEventListener("keydown", function (e) {
          if (e.key === "Escape" && modal.classList.contains("open"))
            closeModal();
        });

        // initial filter application (show all)
        applyFilter();
      })();
    
    
      (function () {
        // FAQ accordion behavior and overlay lift on scroll
        var faqItems = Array.from(document.querySelectorAll(".faq-item"));
        faqItems.forEach(function (item) {
          var q = item.querySelector(".faq-question");
          function toggle() {
            var open = item.classList.toggle("open");
            q.setAttribute("aria-expanded", open ? "true" : "false");
            var toggleEl = q.querySelector(".faq-toggle");
            if (toggleEl) toggleEl.textContent = open ? "−" : "+";
          }
          q.addEventListener("click", toggle);
          q.addEventListener("keydown", function (e) {
            if (e.key === "Enter" || e.key === " ") {
              e.preventDefault();
              toggle();
            }
          });
        });

        // Lift overlay a bit when the why-choose section is visible
        var overlay = document.getElementById("whyOverlay");
        var whySection = overlay ? overlay.closest(".why-choose") : null;
        if (whySection && overlay) {
          var oi = new IntersectionObserver(
            function (entries) {
              entries.forEach(function (ent) {
                if (ent.isIntersecting) {
                  overlay.classList.add("lift");
                } else {
                  overlay.classList.remove("lift");
                }
              });
            },
            { threshold: [0, 0.25, 0.6] }
          );
          oi.observe(whySection);
        }

        // Small enhancement: hover image scale when overlay lifts
        var stickyFigure = document.querySelector(".sticky-figure");
        if (stickyFigure && overlay) {
          var io2 = new IntersectionObserver(
            function (entries) {
              entries.forEach(function (ent) {
                if (ent.isIntersecting) {
                  stickyFigure.querySelector("img").style.transform =
                    "scale(1.04)";
                } else {
                  stickyFigure.querySelector("img").style.transform =
                    "scale(1)";
                }
              });
            },
            { threshold: 0.12 }
          );
          io2.observe(stickyFigure);
        }

        // Lower FAQ cards toggle (colored answers)
        var lowerFaqCards = Array.from(
          document.querySelectorAll(".faq-lower .faq-card")
        );
        lowerFaqCards.forEach(function (card) {
          var q = card.querySelector(".faq-q");
          var a = card.querySelector(".faq-a");
          // start collapsed
          a.style.display = "none";
          q.setAttribute("tabindex", "0");
          q.setAttribute("role", "button");
          q.setAttribute("aria-expanded", "false");
          q.addEventListener("click", function () {
            var opened = a.style.display === "block";
            if (opened) {
              a.style.display = "none";
              q.setAttribute("aria-expanded", "false");
            } else {
              a.style.display = "block";
              q.setAttribute("aria-expanded", "true");
            }
          });
          q.addEventListener("keydown", function (e) {
            if (e.key === "Enter" || e.key === " ") {
              e.preventDefault();
              q.click();
            }
          });
        });
      })();
   