﻿document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.loadmore-sectionlisting').forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            const encryptedId = this.getAttribute('data-id');
            LoadMoreProductSection(encryptedId);
        });
    });

    document.querySelectorAll('.loadmore-section').forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            LoadMoreProduct();
        });
    });
});

function LoadMoreProduct() {
    
    var Language = '';
    var Geography = '';

    var loc = window.location.pathname;

    var url;
    if (Language != '') {
        url = "/" + Language + "/businesses/GetData_ProductList_Loadmore";
    }
    else {
        url = "/businesses/GetData_ProductList_Loadmore";

    }

    var cont_id = $('#hdncont_id').val();
    var contpageURL = "";
    var PageNumber = $('#hdnPageNo').val();
    var pageSize = $('#hdnPageSize').val();
    PageNumber = parseInt(PageNumber) + 1;


    $.ajax({
        url: url,
        data: { cont_id: cont_id, contpageURL: contpageURL, pageNumber: PageNumber, pageSize: pageSize },
        cache: false,
        type: "POST",
        success: function (data) {
            //  alert(data);
            // var hdnpageCount = $('#hdnpageCount').val();
            $(data.ModelString).insertBefore("#DivProduct").hide().fadeIn(1000);

            var ajaxModelCount = data.ModelCount;
            $('#hdnPageNo').val(PageNumber);

            if (PageNumber >= ajaxModelCount) {
                $("#loadMore").remove();
            }



        },
        error: function (xhr, status, error) {

            console.log(xhr.responseText + '    ' + cont_id);
            alert("message : \n" +
                "An error occurred, for more info check the js console" +
                "\n status : \n" + status + " \n error : \n" + error);
        }
    });



}


function LoadMoreProductSection(Id) {

    //debugger;
    var Language = '';
    var Geography = '';

    var loc = window.location.pathname;

    var url;
    if (Language != '') {
        url = "/" + Language + "/businesses/GetData_ProductList_Loadmore";
    }
    else {
        url = "/businesses/GetData_ProductList_Loadmore";

    }


    var cont_id = Id;
    var contpageURL = "";
    var PageNumber = $('#hdnPageNo').val();
    var pageSize = $('#hdnPageSize').val();
    PageNumber = parseInt(PageNumber) + 1;


    $.ajax({
        url: url,
        data: { cont_id: cont_id, contpageURL: contpageURL, pageNumber: PageNumber, pageSize: pageSize },
        cache: false,
        type: "POST",
        success: function (data) {
            //  alert(data);
            // var hdnpageCount = $('#hdnpageCount').val();
            $(data.ModelString).insertBefore("#DivProduct_" + Id).hide().fadeIn(1000);

            var ajaxModelCount = data.ModelCount;
            $('#hdnPageNo').val(PageNumber);

            if (PageNumber >= ajaxModelCount) {
                $("#loadMore_" + Id).remove();
            }



        },
        error: function (xhr, status, error) {

            console.log(xhr.responseText + '    ' + cont_id);
            alert("message : \n" +
                "An error occurred, for more info check the js console" +
                "\n status : \n" + status + " \n error : \n" + error);
        }
    });



}


function GetProductDisplay(Id) {
    //debugger;
    var Language = '';
    var Geography = '';

    var loc = window.location.pathname;

    var url;
    if (Language != '') {
        url = "/" + Language + "/businesses/GetData_ProductList_byId";
    }
    else {
        url = "/businesses/GetData_ProductList_byId";

    }


    var cont_id = Id;
    var contpageURL = "";

    $.ajax({
        url: url,
        data: { cont_id: cont_id },
        cache: false,
        type: "POST",
        success: function (data) {
            //alert(data.ModelString);
            // var hdnpageCount = $('#hdnpageCount').val();
            //$(data.ModelString).insertBefore("#DivProduct_" + Id).hide().fadeIn(1000);
            //$(data.ModelString).insertBefore("#DivProduct_").hide().fadeIn(1000);
            $("#DivProductDisplay").empty();
            $("#DivProductDisplay").append(data.ModelString);
            $('#productModal').modal('show');

           

        },
        error: function (xhr, status, error) {

            console.log(xhr.responseText + '    ' + cont_id);
            alert("message : \n" +
                "An error occurred, for more info check the js console" +
                "\n status : \n" + status + " \n error : \n" + error);
        }
    });



}
